--This is written to batch inject container spawn rules for clothing and other items.
--Written by GanydeBielovzki for the Frockin' Splendor franchise and spin-offs.
--To copy,  modify or otherwise use this code the original creator must be credited.

require 'Items/ProceduralDistributions'

local function BatchRuleInjection(container, ...)
    for i = 1, select('#', ...), 2 do
        local item, weight = select(i, ...)
        table.insert(ProceduralDistributions.list[container].items, item)
        table.insert(ProceduralDistributions.list[container].items, weight)
    end
end

--Lootbox Injection
BatchRuleInjection("BedroomDresser","Bag_FrockinSplendor5_ToyBox", 0.25)
BatchRuleInjection("WardrobeWoman","Bag_FrockinSplendor5_ToyBox", 0.25)
BatchRuleInjection("CrateClothesRandom","Bag_FrockinSplendor5_ToyBox", 0.5)
BatchRuleInjection("StripClubDressers","Bag_FrockinSplendor5_ToyBox", 10)

-- Batch Injection:
BatchRuleInjection("ClothingStoresShirts",
    "Base.Cotton_Blouse", 0.5,
    "Base.Cotton_Blouse_V", 0.8,
    "Base.Cotton_Blouse_V_Cropped", 0.5,
    "Base.Cotton_Blouse_V_Cropped_Tiny", 0.5,
    "Base.Lumberjack_Shirt_10", 4.7,
    "Base.Lumberjack_Cropped_Shirt_10", 3.5,
    "Base.Lumberjack_Sleeveless_Shirt_10", 3.5,
    "Base.Denim_Shirt_10", 0.8,
    "Base.Denim_Sleeveless_Shirt_10", 0.7
)

BatchRuleInjection("ClothingStoresWoman",
    "Base.Cotton_Blouse", 1.0,
    "Base.Cotton_Blouse_V", 1.0,
    "Base.Cotton_Blouse_V_Cropped", 0.8,
    "Base.Cotton_Blouse_V_Cropped_Tiny", 0.7,
    "Base.Denim_Bandeau", 0.5,
    "Base.Denim_Bandeau_Tiny", 0.5,
    "Base.Denim_Top", 0.8,
    "Base.Denim_CropTop", 0.7,
    "Base.TannedLeather_Top", 0.7,
    "Base.TannedLeather_TopSkimpy", 0.5,
    "Base.TannedLeather_CropTop", 0.7,
    "Base.TannedLeather_Bandeau", 0.5,
    "Base.TannedLeather_Bandeau_Tiny", 0.5,
    "Base.TannedLeather_Corset_OuterLayer", 0.8,
    "Base.TannedLeather_Corset_UB_OuterLayer", 0.7,
    "Base.TannedLeather_Corset_Strap_OuterLa", 0.5,
    "Base.TannedLeather_Corset_UB_Strap_Oute", 0.5,
    "Base.TannedLeather_WaistCoat", 0.7
)

BatchRuleInjection("ClothingStoresJeans",
    "Base.Mesh_Denim_Pants", 0.8,
    "Base.Mesh_Denim_PantsFlared", 0.7,
    "Base.Mesh_Denim_PantsChaps", 0.5,
    "Base.Denim_Shorts_J", 0.5
)

BatchRuleInjection("ClothingStoresJackets",
    "Base.Denim_Jacket_Cropped", 2.7,
    "Base.Denim_Jacket_O", 2.9,
    "Base.Denim_JacketReinforced_O", 2.8,
    "Base.Denim_JacketShort_O", 2.8,
    "Base.Denim_VestJacket_O",0.75,
    "Base.Denim_VestJacketCropped_O", 2.5,
    "Base.Denim_VestJacketShort_O", 2.7,
    "Base.Denim_Overshirt_O", 2.8,
    "Base.FurCoat_Fur", 2.5,
    "Base.FurJacketShort_O", 2.5,
	"Base.Denim_Jacket_Cropped", 2.5,
	"Base.Denim_Jacket", 2.5,
	"Base.Denim_Jacket_O", 2.5,
	"Base.Denim_JacketReinforced", 2.5,
	"Base.Denim_JacketReinforced_O", 2.5,
	"Base.Denim_JacketShort", 2.5,
	"Base.Denim_JacketShort_O", 2.5,
	"Base.Denim_VestJacket", 2.5,
	"Base.Denim_VestJacket_O", 2.5,
	"Base.Denim_VestJacketCropped", 2.5,
	"Base.Denim_VestJacketCropped_O", 2.5,
	"Base.Denim_VestJacketShort", 2.5,
	"Base.Denim_VestJacketShort_O", 2.5,
	"Base.Denim_LongCoat", 2.5,
	"Base.Denim_LongCoat_O", 2.5,
	"Base.Denim_LongCoatShort", 2.5,
	"Base.Denim_LongCoatShort_O", 2.5,
	"Base.Denim_LongCoatShort_Reinforced", 2.5,
	"Base.Denim_LongCoatShort_Reinforced_O", 2.5,
	"Base.Denim_LongCoatShortSleeveless", 2.5,
	"Base.Denim_LongCoatShortSleeveless_O", 2.5,
	"Base.Denim_TrenchCoat_Long_O", 2.5,
	"Base.Denim_TrenchCoat_Short_O", 2.5,
	"Base.TannedLeather_Jacket_Cropped", 2.5,
	"Base.TannedLeather_LongestCoat", 2.5,
	"Base.TannedLeather_LongestCoat_O", 2.5,
	"Base.TannedLeather_LongerCoat", 2.5,
	"Base.TannedLeather_LongerCoat_O", 2.5,
	"Base.TannedLeather_LongCoat", 2.5,
	"Base.TannedLeather_LongCoat_O", 2.5,
	"Base.TannedLeather_Jacket", 2.5,
	"Base.TannedLeather_Jacket_O", 2.5,
	"Base.TannedLeather_Jacket_MidLength", 2.5,
	"Base.TannedLeather_Jacket_MidLength_O", 2.5,
	"Base.TannedLeather_TrenchCoat_Long_O", 2.5,
	"Base.TannedLeather_TrenchCoat_Short_O", 2.5,
	"Base.TannedLeather_LongestCoat_Winter", 2.5,
	"Base.TannedLeather_LongestCoat_Winter_O", 2.5,
	"Base.TannedLeather_LongerCoat_Winter", 2.5,
	"Base.TannedLeather_LongerCoat_Winter_O", 2.5,
	"Base.Cotton_LongestCoat_VintageMil", 2.5,	
	"Base.Cotton_LongestCoat_VintageMil_O", 2.5
)

BatchRuleInjection("ClothingStoresJacketsLeather",
    "Base.Denim_JacketReinforced_O", 0.5,
    "Base.Denim_LongCoatShort_Reinforced_O", 0.5,
    "Base.TannedLeather_Jacket_Cropped", 0.8,
    "Base.TannedLeather_LongestCoat_O", 0.7,
    "Base.TannedLeather_LongerCoat_O", 0.8,
    "Base.TannedLeather_LongCoat_O", 0.9,
    "Base.TannedLeather_Jacket_O", 1.0,
    "Base.TannedLeather_Jacket_MidLength_O", 0.9,
    "Base.TannedLeather_TrenchCoat_Long_O", 0.8,
    "Base.TannedLeather_TrenchCoat_Short_O", 0.9,
    "Base.TannedLeather_LongestCoat_Winter_O", 0.5,
    "Base.TannedLeather_LongerCoat_Winter_O", 0.7,
	"Base.Denim_Jacket_Cropped", 0.5,
	"Base.Denim_Jacket", 0.5,
	"Base.Denim_Jacket_O", 0.5,
	"Base.Denim_JacketReinforced", 0.5,
	"Base.Denim_JacketReinforced_O", 0.5,
	"Base.Denim_JacketShort", 0.5,
	"Base.Denim_JacketShort_O", 0.5,
	"Base.Denim_VestJacket", 0.5,
	"Base.Denim_VestJacket_O", 0.5,
	"Base.Denim_VestJacketCropped", 0.5,
	"Base.Denim_VestJacketCropped_O", 0.5,
	"Base.Denim_VestJacketShort", 0.5,
	"Base.Denim_VestJacketShort_O", 0.5,
	"Base.Denim_LongCoat", 0.5,
	"Base.Denim_LongCoat_O", 0.5,
	"Base.Denim_LongCoatShort", 0.5,
	"Base.Denim_LongCoatShort_O", 0.5,
	"Base.Denim_LongCoatShort_Reinforced", 0.5,
	"Base.Denim_LongCoatShort_Reinforced_O", 0.5,
	"Base.Denim_LongCoatShortSleeveless", 0.5,
	"Base.Denim_LongCoatShortSleeveless_O", 0.5,
	"Base.Denim_TrenchCoat_Long_O", 0.5,
	"Base.Denim_TrenchCoat_Short_O", 0.5,
	"Base.TannedLeather_Jacket_Cropped", 0.5,
	"Base.TannedLeather_LongestCoat", 0.5,
	"Base.TannedLeather_LongestCoat_O", 0.5,
	"Base.TannedLeather_LongerCoat", 0.5,
	"Base.TannedLeather_LongerCoat_O", 0.5,
	"Base.TannedLeather_LongCoat", 0.5,
	"Base.TannedLeather_LongCoat_O", 0.5,
	"Base.TannedLeather_Jacket", 0.5,
	"Base.TannedLeather_Jacket_O", 0.5,
	"Base.TannedLeather_Jacket_MidLength", 0.5,
	"Base.TannedLeather_Jacket_MidLength_O", 0.5,
	"Base.TannedLeather_TrenchCoat_Long_O", 0.5,
	"Base.TannedLeather_TrenchCoat_Short_O", 0.5,
	"Base.TannedLeather_LongestCoat_Winter", 0.5,
	"Base.TannedLeather_LongestCoat_Winter_O", 0.5,
	"Base.TannedLeather_LongerCoat_Winter", 0.5,
	"Base.TannedLeather_LongerCoat_Winter_O", 0.5,
	"Base.Cotton_LongestCoat_VintageMil", 0.5,	
	"Base.Cotton_LongestCoat_VintageMil_O", 0.5
)

BatchRuleInjection("ClothingStoresJumpers",
    "Base.Denim_LongCoat_O", 0.5,
    "Base.Denim_LongCoatShort_O", 0.7,
    "Base.Denim_TrenchCoat_Long_O", 0.8,
    "Base.Denim_TrenchCoat_Short_O", 0.9
)

BatchRuleInjection("ClothingStoresSummer",
    "Base.Mesh_Denim_Shorts", 0.9,
    "Base.Mesh_Denim_ShortShorts", 0.8,
    "Base.Mesh_Denim_ShorterShorts", 0.7,
    "Base.Skin_Denim_Shorts", 0.5,
    "Base.Mesh_Denim_LongShorts", 0.8,
    "Base.Denim_Shorts_J", 0.7,
    "Base.TMesh_TannedLeather_Shorts", 0.8,
    "Base.TMesh_TannedLeather_ShortShorts", 0.7,
    "Base.TMesh_TannedLeather_ShorterShorts", 0.5,
    "Base.TannedLeather_Shorts_J", 0.7
)

BatchRuleInjection("ClothingStoresSport",
    "Base.Mesh_Denim_Shorts", 0.7,
    "Base.Mesh_Denim_ShortShorts", 0.5,
    "Base.FF_Shoe_Trainers", 1.0,
    "Base.FF_Shoe_TrainersBlack", 0.9,
    "Base.FF_Shoe_TrainersWhite", 0.9,
    "Base.FF_Shoe_Common", 0.8,
    "Base.TannedLeather_Leotard", 0.7,
    "Base.TannedLeather_Leotard_MC", 0.5,
    "Base.TannedLeather_Leotard_HC", 0.5,
    "Base.TannedLeather_LeotardUB", 0.5,
    "Base.TannedLeather_LeotardUB_MC", 0.5,
    "Base.TannedLeather_LeotardUB_HC", 0.5
)

BatchRuleInjection("ClothingStoresDress",
    "Base.Denim_Skirt_Short", 0.8,
    "Base.Denim_Skirt_Short_LW", 0.7,
    "Base.Denim_Skirt_Longer", 0.9,
    "Base.Denim_Skirt_Long", 1.0,
    "Base.Denim_Skirt_Mesh_HW", 0.5,
    "Base.Denim_Skirt_Mesh_LW", 0.5,
    "Base.Denim_SkirtPleated", 0.8,
    "Base.Denim_SkirtPleated_Frilled", 0.7,
    "Base.Mesh_Denim_Skirt_Longer", 0.5,
    "Base.TannedLeather_Skirt_Mesh_HW", 0.5,
    "Base.TannedLeather_Skirt_Mesh_LW", 0.5,
    "Base.TannedLeather_Skirt_Mesh_LerW", 0.7,
    "Base.TannedLeather_Skirt_MeshFrilled_HW", 0.5,
    "Base.TannedLeather_Skirt_MeshFrilled_LW", 0.5,
    "Base.TannedLeather_Skirt_MeshFrilled_LerW", 0.5,
	"Base.TannedLeather_SkirtMicro_MeshFrilled", 0.5,
    "Base.TannedLeather_SkirtMicro_Mesh", 0.5,
    "Base.TannedLeather_SkirtMicro_MeshFrill", 0.5,
    "Base.TannedLeather_Long_Skirt", 0.8,
    "Base.TannedLeather_Skirt_Mid", 0.9,
    "Base.TannedLeather_Skirt_Short", 1.0,
    "Base.TannedLeather_Skirt_Shorter", 0.7
)

BatchRuleInjection("ClothingStorageWinter",
    "Base.FurCoat_Fur", 1.8,
    "Base.FurJacketShort_O", 1.9,
    "Base.TannedLeather_LongestCoat_Winter_O", 1.8,
    "Base.TannedLeather_LongerCoat_Winter_O", 1.9,
    "Base.FF_Boots_UGG", 1.7,
    "Base.FF_Boots_UGG_Thighhigh", 1.5,
    "Base.FF_Boots_UGG_Kneehigh", 1.8,
    "Base.FF_Boots_UGG_DwarfHeel", 1.5,
    "Base.FF_Boots_UGG_Heel", 1.5,
    "Base.FF_Boots_UGG_ThighhighHeel", 1.5,
    "Base.FF_Boots_UGG_KneehighHeel", 1.5,
	"Base.Denim_Jacket_Cropped", 1.5,
	"Base.Denim_Jacket", 1.5,
	"Base.Denim_Jacket_O", 1.5,
	"Base.Denim_JacketReinforced", 1.5,
	"Base.Denim_JacketReinforced_O", 1.5,
	"Base.Denim_JacketShort", 1.5,
	"Base.Denim_JacketShort_O", 1.5,
	"Base.Denim_VestJacket", 1.5,
	"Base.Denim_VestJacket_O", 1.5,
	"Base.Denim_VestJacketCropped", 1.5,
	"Base.Denim_VestJacketCropped_O", 1.5,
	"Base.Denim_VestJacketShort", 1.5,
	"Base.Denim_VestJacketShort_O", 1.5,
	"Base.Denim_LongCoat", 1.5,
	"Base.Denim_LongCoat_O", 1.5,
	"Base.Denim_LongCoatShort", 1.5,
	"Base.Denim_LongCoatShort_O", 1.5,
	"Base.Denim_LongCoatShort_Reinforced", 1.5,
	"Base.Denim_LongCoatShort_Reinforced_O", 1.5,
	"Base.Denim_LongCoatShortSleeveless", 1.5,
	"Base.Denim_LongCoatShortSleeveless_O", 1.5,
	"Base.Denim_TrenchCoat_Long_O", 1.5,
	"Base.Denim_TrenchCoat_Short_O", 1.5,
	"Base.TannedLeather_Jacket_Cropped", 1.5,
	"Base.TannedLeather_LongestCoat", 1.5,
	"Base.TannedLeather_LongestCoat_O", 1.5,
	"Base.TannedLeather_LongerCoat", 1.5,
	"Base.TannedLeather_LongerCoat_O", 1.5,
	"Base.TannedLeather_LongCoat", 1.5,
	"Base.TannedLeather_LongCoat_O", 1.5,
	"Base.TannedLeather_Jacket", 1.5,
	"Base.TannedLeather_Jacket_O", 1.5,
	"Base.TannedLeather_Jacket_MidLength", 1.5,
	"Base.TannedLeather_Jacket_MidLength_O", 1.5,
	"Base.TannedLeather_TrenchCoat_Long_O", 1.5,
	"Base.TannedLeather_TrenchCoat_Short_O", 1.5,
	"Base.TannedLeather_LongestCoat_Winter", 1.5,
	"Base.TannedLeather_LongestCoat_Winter_O", 1.5,
	"Base.TannedLeather_LongerCoat_Winter", 1.5,
	"Base.TannedLeather_LongerCoat_Winter_O", 1.5,
	"Base.Cotton_LongestCoat_VintageMil", 1.5,	
	"Base.Cotton_LongestCoat_VintageMil_O", 1.5
)

BatchRuleInjection("ClothingStoresShoes",
    "Base.FF_Boots_HF_New", 2,
    "Base.FF_Boots_HF_New_Longest", 2,
    "Base.FF_Boots_HF_New_Longer", 2,
    "Base.FF_Boots_HF_New_Long", 2,
    "Base.FF_Boots_Leather", 2,
    "Base.FF_Boots_Leather_Short", 2,
    "Base.FF_Boots_Cowboy", 2,
    "Base.FF_Boots_Cowboy_Plain", 2,
    "Base.FF_Shoe_Boots_Ankle", 2,
    "Base.FF_Shoe_Boots_Ankle_Steel", 2,
    "Base.FF_Boots_Common", 2,
    "Base.FF_Boots_Platform_Thighhigh", 2,
    "Base.FF_Boots_Platform_Kneehigher", 2,
    "Base.FF_Boots_Platform_Kneehigh", 2,
    "Base.FF_Boots_Platform_Ankle", 2,
    "Base.FF_Boots_Platform_AnkleLow", 2,
    "Base.FF_Boots_Pointy_AnkleLow", 2,
    "Base.FF_Boots_Pointy_Ankle", 2,
    "Base.FF_Boots_Pointy_Kneehigh", 2,
	"Base.FF_Boots_HF_New", 2,
	"Base.FF_Boots_HF_New_Longest", 2,
	"Base.FF_Boots_HF_New_Longer", 2,
	"Base.FF_Boots_HF_New_Long", 2,
	"Base.FF_Shoe_Boots_Ankle_Platform", 2,
	"Base.FF_Boots_HighHeels", 2,
	"Base.FF_Shoe_Women", 2,
	"Base.FF_Shoe_Women_Platform", 2,
	"Base.FF_Shoe_Women_2", 2,
	"Base.FF_Shoe_Moccasin", 2,
	"Base.FF_Boots_UGG_DwarfHeel", 2,
	"Base.FF_Boots_UGG_Heel", 2,
	"Base.FF_Boots_UGG_ThighhighHeel", 2,
	"Base.FF_Boots_UGG_KneehighHeel", 2,
	"Base.FF_Boots_UGG", 2,
	"Base.FF_Boots_UGG_Thighhigh", 2,
	"Base.FF_Boots_UGG_Kneehigh", 2,
	"Base.FF_Boots_Leather", 2,
	"Base.FF_Boots_Leather_Short", 2,
	"Base.FF_Boots_Cowboy", 2,
	"Base.FF_Boots_Cowboy_Plain", 2,
	"Base.FF_Shoe_Boots_Ankle", 2,
	"Base.FF_Shoe_Boots_Ankle_Steel", 2,
	"Base.FF_Boots_Common", 2,
	"Base.FF_Shoe_Common", 2,
	"Base.FF_Shoe_Trainers", 2,
	"Base.FF_Shoe_TrainersBlack", 2,
	"Base.FF_Shoe_TrainersWhite", 2,
	"Base.FF_Boots_Platform_Thighhigh", 2,
	"Base.FF_Boots_Platform_Kneehigher", 2,
	"Base.FF_Boots_Platform_Kneehigh", 2,
	"Base.FF_Boots_Platform_Ankle", 2,
	"Base.FF_Boots_Platform_AnkleLow", 2,
	"Base.FF_Boots_PlatformPunk_Thighhigh", 2,
	"Base.FF_Boots_PlatformPunk_Kneehigher", 2,
	"Base.FF_Boots_PlatformPunk_Kneehigh", 2,
	"Base.FF_Boots_Pointy_AnkleLow", 2,
	"Base.FF_Boots_Pointy_Ankle", 2,
	"Base.FF_Boots_Pointy_Kneehigh", 2,
	"Base.FF_Boots_PointySkull_AnkleLow", 2,
	"Base.FF_Boots_PointySkull_Kneehigh", 2,
	"Base.FF_BootsRE_Leather_DwarfHeel", 2,
	"Base.FF_BootsRE_Leather_Heel", 2,
	"Base.FF_BootsRE_Leather_ThighhighHeel", 2,
	"Base.FF_BootsRE_Leather_KneehighHeel", 2,
	"Base.FF_Boots_Military_Thighhigh", 2,
	"Base.FF_Boots_Military_Kneehigher", 2,
	"Base.FF_Boots_Military_Kneehigh", 2,
	"Base.FF_Boots_Military_Ankle", 2
)

BatchRuleInjection("ClosetShelfGeneric",
    "Base.FF_Boots_HF_New", 0.75,
    "Base.FF_Boots_HF_New_Longest", 0.75,
    "Base.FF_Boots_HF_New_Longer", 0.75,
    "Base.FF_Boots_HF_New_Long", 0.75,
    "Base.FF_Boots_Leather", 0.75,
    "Base.FF_Boots_Leather_Short", 0.75,
    "Base.FF_Boots_Cowboy", 0.75,
    "Base.FF_Boots_Cowboy_Plain", 0.75,
    "Base.FF_Shoe_Boots_Ankle", 0.75,
    "Base.FF_Shoe_Boots_Ankle_Steel", 0.75,
    "Base.FF_Boots_Common", 0.75,
    "Base.FF_Boots_Platform_Thighhigh", 0.75,
    "Base.FF_Boots_Platform_Kneehigher", 0.75,
    "Base.FF_Boots_Platform_Kneehigh", 0.75,
    "Base.FF_Boots_Platform_Ankle", 0.75,
    "Base.FF_Boots_Platform_AnkleLow", 0.75,
    "Base.FF_Boots_Pointy_AnkleLow", 0.75,
    "Base.FF_Boots_Pointy_Ankle", 0.75,
    "Base.FF_Boots_Pointy_Kneehigh", 0.75,
	"Base.FF_Boots_HF_New", 0.75,
	"Base.FF_Boots_HF_New_Longest", 0.75,
	"Base.FF_Boots_HF_New_Longer", 0.75,
	"Base.FF_Boots_HF_New_Long", 0.75,
	"Base.FF_Shoe_Boots_Ankle_Platform", 0.75,
	"Base.FF_Boots_HighHeels", 0.75,
	"Base.FF_Shoe_Women", 0.75,
	"Base.FF_Shoe_Women_Platform", 0.75,
	"Base.FF_Shoe_Women_1", 0.75,
	"Base.FF_Shoe_Moccasin", 0.75,
	"Base.FF_Boots_UGG_DwarfHeel", 0.75,
	"Base.FF_Boots_UGG_Heel", 0.75,
	"Base.FF_Boots_UGG_ThighhighHeel", 0.75,
	"Base.FF_Boots_UGG_KneehighHeel", 0.75,
	"Base.FF_Boots_UGG", 0.75,
	"Base.FF_Boots_UGG_Thighhigh", 0.75,
	"Base.FF_Boots_UGG_Kneehigh", 0.75,
	"Base.FF_Boots_Leather", 0.75,
	"Base.FF_Boots_Leather_Short", 0.75,
	"Base.FF_Boots_Cowboy", 0.75,
	"Base.FF_Boots_Cowboy_Plain", 0.75,
	"Base.FF_Shoe_Boots_Ankle", 0.75,
	"Base.FF_Shoe_Boots_Ankle_Steel", 0.75,
	"Base.FF_Boots_Common", 0.75,
	"Base.FF_Shoe_Common", 0.75,
	"Base.FF_Shoe_Trainers", 0.75,
	"Base.FF_Shoe_TrainersBlack", 0.75,
	"Base.FF_Shoe_TrainersWhite", 0.75,
	"Base.FF_Boots_Platform_Thighhigh", 0.75,
	"Base.FF_Boots_Platform_Kneehigher", 0.75,
	"Base.FF_Boots_Platform_Kneehigh", 0.75,
	"Base.FF_Boots_Platform_Ankle", 0.75,
	"Base.FF_Boots_Platform_AnkleLow", 0.75,
	"Base.FF_Boots_PlatformPunk_Thighhigh", 0.75,
	"Base.FF_Boots_PlatformPunk_Kneehigher", 0.75,
	"Base.FF_Boots_PlatformPunk_Kneehigh", 0.75,
	"Base.FF_Boots_Pointy_AnkleLow", 0.75,
	"Base.FF_Boots_Pointy_Ankle", 0.75,
	"Base.FF_Boots_Pointy_Kneehigh", 0.75,
	"Base.FF_Boots_PointySkull_AnkleLow", 0.75,
	"Base.FF_Boots_PointySkull_Kneehigh", 0.75,
	"Base.FF_BootsRE_Leather_DwarfHeel", 0.75,
	"Base.FF_BootsRE_Leather_Heel", 0.75,
	"Base.FF_BootsRE_Leather_ThighhighHeel", 0.75,
	"Base.FF_BootsRE_Leather_KneehighHeel", 0.75,
	"Base.FF_Boots_Military_Thighhigh", 0.75,
	"Base.FF_Boots_Military_Kneehigher", 0.75,
	"Base.FF_Boots_Military_Kneehigh", 0.75,
	"Base.FF_Boots_Military_Ankle", 1
)

BatchRuleInjection("ClothingStoresShoesLeather",
    "Base.FF_Boots_HF_New", 2,
    "Base.FF_Boots_HF_New_Longest", 2,
    "Base.FF_Boots_HF_New_Longer", 2,
    "Base.FF_Boots_HF_New_Long", 2,
    "Base.FF_Boots_Leather", 2,
    "Base.FF_Boots_Leather_Short", 2,
    "Base.FF_Boots_Cowboy", 2,
    "Base.FF_Boots_Cowboy_Plain", 2,
    "Base.FF_Shoe_Boots_Ankle", 2,
    "Base.FF_Shoe_Boots_Ankle_Steel", 2,
    "Base.FF_Boots_Common", 2,
    "Base.FF_Boots_Platform_Thighhigh", 2,
    "Base.FF_Boots_Platform_Kneehigher", 2,
    "Base.FF_Boots_Platform_Kneehigh", 2,
    "Base.FF_Boots_Platform_Ankle", 2,
    "Base.FF_Boots_Platform_AnkleLow", 2,
    "Base.FF_Boots_Pointy_AnkleLow", 2,
    "Base.FF_Boots_Pointy_Ankle", 2,
    "Base.FF_Boots_Pointy_Kneehigh", 2,
	"Base.FF_Boots_HF_New", 2,
	"Base.FF_Boots_HF_New_Longest", 2,
	"Base.FF_Boots_HF_New_Longer", 2,
	"Base.FF_Boots_HF_New_Long", 2,
	"Base.FF_Shoe_Boots_Ankle_Platform", 2,
	"Base.FF_Boots_HighHeels", 2,
	"Base.FF_Shoe_Women", 2,
	"Base.FF_Shoe_Women_Platform", 2,
	"Base.FF_Shoe_Women_2", 2,
	"Base.FF_Shoe_Moccasin", 2,
	"Base.FF_Boots_UGG_DwarfHeel", 2,
	"Base.FF_Boots_UGG_Heel", 2,
	"Base.FF_Boots_UGG_ThighhighHeel", 2,
	"Base.FF_Boots_UGG_KneehighHeel", 2,
	"Base.FF_Boots_UGG", 2,
	"Base.FF_Boots_UGG_Thighhigh", 2,
	"Base.FF_Boots_UGG_Kneehigh", 2,
	"Base.FF_Boots_Leather", 2,
	"Base.FF_Boots_Leather_Short", 2,
	"Base.FF_Boots_Cowboy", 2,
	"Base.FF_Boots_Cowboy_Plain", 2,
	"Base.FF_Shoe_Boots_Ankle", 2,
	"Base.FF_Shoe_Boots_Ankle_Steel", 2,
	"Base.FF_Boots_Common", 2,
	"Base.FF_Shoe_Common", 2,
	"Base.FF_Shoe_Trainers", 2,
	"Base.FF_Shoe_TrainersBlack", 2,
	"Base.FF_Shoe_TrainersWhite", 2,
	"Base.FF_Boots_Platform_Thighhigh", 2,
	"Base.FF_Boots_Platform_Kneehigher", 2,
	"Base.FF_Boots_Platform_Kneehigh", 2,
	"Base.FF_Boots_Platform_Ankle", 2,
	"Base.FF_Boots_Platform_AnkleLow", 2,
	"Base.FF_Boots_PlatformPunk_Thighhigh", 2,
	"Base.FF_Boots_PlatformPunk_Kneehigher", 2,
	"Base.FF_Boots_PlatformPunk_Kneehigh", 2,
	"Base.FF_Boots_Pointy_AnkleLow", 2,
	"Base.FF_Boots_Pointy_Ankle", 2,
	"Base.FF_Boots_Pointy_Kneehigh", 2,
	"Base.FF_Boots_PointySkull_AnkleLow", 2,
	"Base.FF_Boots_PointySkull_Kneehigh", 2,
	"Base.FF_BootsRE_Leather_DwarfHeel", 2,
	"Base.FF_BootsRE_Leather_Heel", 2,
	"Base.FF_BootsRE_Leather_ThighhighHeel", 2,
	"Base.FF_BootsRE_Leather_KneehighHeel", 2,
	"Base.FF_Boots_Military_Thighhigh", 2,
	"Base.FF_Boots_Military_Kneehigher", 2,
	"Base.FF_Boots_Military_Kneehigh", 2,
	"Base.FF_Boots_Military_Ankle", 2
)

BatchRuleInjection("ClothingStoresBoots",
    "Base.FF_Boots_HF_New", 2,
    "Base.FF_Boots_HF_New_Longest", 2,
    "Base.FF_Boots_HF_New_Longer", 2,
    "Base.FF_Boots_HF_New_Long", 2,
    "Base.FF_Boots_Leather", 2,
    "Base.FF_Boots_Leather_Short", 2,
    "Base.FF_Boots_Cowboy", 2,
    "Base.FF_Boots_Cowboy_Plain", 2,
    "Base.FF_Shoe_Boots_Ankle", 2,
    "Base.FF_Shoe_Boots_Ankle_Steel", 2,
    "Base.FF_Boots_Common", 2,
    "Base.FF_Boots_Platform_Thighhigh", 2,
    "Base.FF_Boots_Platform_Kneehigher", 2,
    "Base.FF_Boots_Platform_Kneehigh", 2,
    "Base.FF_Boots_Platform_Ankle", 2,
    "Base.FF_Boots_Platform_AnkleLow", 2,
    "Base.FF_Boots_Pointy_AnkleLow", 2,
    "Base.FF_Boots_Pointy_Ankle", 2,
    "Base.FF_Boots_Pointy_Kneehigh", 2,
	"Base.FF_Boots_HF_New", 2,
	"Base.FF_Boots_HF_New_Longest", 2,
	"Base.FF_Boots_HF_New_Longer", 2,
	"Base.FF_Boots_HF_New_Long", 2,
	"Base.FF_Shoe_Boots_Ankle_Platform", 2,
	"Base.FF_Boots_HighHeels", 2,
	"Base.FF_Shoe_Women", 2,
	"Base.FF_Shoe_Women_Platform", 2,
	"Base.FF_Shoe_Women_2", 2,
	"Base.FF_Shoe_Moccasin", 2,
	"Base.FF_Boots_UGG_DwarfHeel", 2,
	"Base.FF_Boots_UGG_Heel", 2,
	"Base.FF_Boots_UGG_ThighhighHeel", 2,
	"Base.FF_Boots_UGG_KneehighHeel", 2,
	"Base.FF_Boots_UGG", 2,
	"Base.FF_Boots_UGG_Thighhigh", 2,
	"Base.FF_Boots_UGG_Kneehigh", 2,
	"Base.FF_Boots_Leather", 2,
	"Base.FF_Boots_Leather_Short", 2,
	"Base.FF_Boots_Cowboy", 2,
	"Base.FF_Boots_Cowboy_Plain", 2,
	"Base.FF_Shoe_Boots_Ankle", 2,
	"Base.FF_Shoe_Boots_Ankle_Steel", 2,
	"Base.FF_Boots_Common", 2,
	"Base.FF_Shoe_Common", 2,
	"Base.FF_Shoe_Trainers", 2,
	"Base.FF_Shoe_TrainersBlack", 2,
	"Base.FF_Shoe_TrainersWhite", 2,
	"Base.FF_Boots_Platform_Thighhigh", 2,
	"Base.FF_Boots_Platform_Kneehigher", 2,
	"Base.FF_Boots_Platform_Kneehigh", 2,
	"Base.FF_Boots_Platform_Ankle", 2,
	"Base.FF_Boots_Platform_AnkleLow", 2,
	"Base.FF_Boots_PlatformPunk_Thighhigh", 2,
	"Base.FF_Boots_PlatformPunk_Kneehigher", 2,
	"Base.FF_Boots_PlatformPunk_Kneehigh", 2,
	"Base.FF_Boots_Pointy_AnkleLow", 2,
	"Base.FF_Boots_Pointy_Ankle", 2,
	"Base.FF_Boots_Pointy_Kneehigh", 2,
	"Base.FF_Boots_PointySkull_AnkleLow", 2,
	"Base.FF_Boots_PointySkull_Kneehigh", 2,
	"Base.FF_BootsRE_Leather_DwarfHeel", 2,
	"Base.FF_BootsRE_Leather_Heel", 2,
	"Base.FF_BootsRE_Leather_ThighhighHeel", 2,
	"Base.FF_BootsRE_Leather_KneehighHeel", 2,
	"Base.FF_Boots_Military_Thighhigh", 2,
	"Base.FF_Boots_Military_Kneehigher", 2,
	"Base.FF_Boots_Military_Kneehigh", 2,
	"Base.FF_Boots_Military_Ankle", 2
)

BatchRuleInjection("ClothingStoresPantsLeather",
    "Base.TMesh_TannedLeather_Pants", 0.9,
    "Base.TMesh_TannedLeather_LongShorts", 0.8,
    "Base.TSkin_TannedLeather_Pants", 0.7,
    "Base.TannedLeather_Shorts_J", 0.8
)

BatchRuleInjection("ClothingStoresHeadwear",
    "Base.Hat_Cowboy_Flat", 0.8
)

BatchRuleInjection("ArmySurplusFootwear",
    "Base.FF_Boots_Military_Thighhigh", 0.8,
    "Base.FF_Boots_Military_Kneehigher", 0.9,
    "Base.FF_Boots_Military_Kneehigh", 1.0,
    "Base.FF_Boots_Military_Ankle", 0.9,
    "Base.FF_Boots_Common", 0.7,
    "Base.FF_Shoe_Common", 0.5
)

BatchRuleInjection("BandMerchClothes",
    "Base.Denim_Jacket_O", 0.7,
    "Base.Denim_Jacket_Cropped", 0.5,
    "Base.TannedLeather_Jacket_O", 0.5,
    "Base.TannedLeather_Jacket_Cropped", 0.5,
    "Base.FF_Boots_PlatformPunk_Thighhigh", 0.5,
    "Base.FF_Boots_PlatformPunk_Kneehigher", 0.5,
    "Base.FF_Boots_PlatformPunk_Kneehigh", 0.5,
	"Base.Cotton_Blouse", 0.5,
    "Base.Cotton_Blouse_V", 0.8,
    "Base.Cotton_Blouse_V_Cropped", 0.5,
    "Base.Cotton_Blouse_V_Cropped_Tiny", 0.5,
    "Base.Lumberjack_Shirt_10", 0.7,
    "Base.Lumberjack_Cropped_Shirt_10", 0.5,
    "Base.Lumberjack_Sleeveless_Shirt_10", 0.5,
    "Base.Denim_Shirt_10", 0.8,
    "Base.Denim_Sleeveless_Shirt_10", 0.7
)

BatchRuleInjection("BedroomDresser",
    "Base.Cotton_Blouse", 0.5,
    "Base.Lumberjack_Shirt_10", 0.5,
    "Base.Denim_Shirt_10", 0.5,
    "Base.Denim_Shorts_J", 0.5,
    "Base.FF_Shoe_Common", 0.5,
    "Base.FF_Shoe_Trainers", 0.5,
	"Base.Denim_Bandeau", 0.5,
	"Base.Denim_Bandeau_Tiny", 0.5,
	"Base.Denim_Top", 0.5,
	"Base.Denim_CropTop", 0.5,
	"Base.Denim_Skirt_Short", 0.5,
	"Base.Denim_Skirt_Short_LW", 0.5,
	"Base.Denim_Skirt_Longer", 0.5,
	"Base.Denim_Skirt_Long", 0.5,
	"Base.Denim_Skirt_Mesh_HW", 0.5,
	"Base.Denim_Skirt_Mesh_LW", 0.5,
	"Base.Denim_SkirtPleated", 0.5,
	"Base.Denim_SkirtPleated_Frilled", 0.5,
	"Base.Mesh_Denim_Skirt_Longer", 0.5,
	"Base.Mesh_Denim_Pants", 0.5,
	"Base.Mesh_Denim_PantsFlared", 0.5,
	"Base.Mesh_Denim_PantsChaps", 0.5,
	"Base.Mesh_Denim_LongShorts", 0.5,
	"Base.Skin_Denim_Pants_High", 0.5,
	"Base.Skin_Denim_Pants_J", 0.5,
	"Base.FurJacketShort_O", 0.5,
	"Base.Belt_Generic", 0.5
)

BatchRuleInjection("BedroomDresser",
	"Base.TannedLeather_Jacket_Cropped", 0.5,
	"Base.TannedLeather_LongestCoat", 0.5,
	"Base.TannedLeather_LongestCoat_O", 0.5,
	"Base.TannedLeather_LongerCoat", 0.5,
	"Base.TannedLeather_LongerCoat_O", 0.5,
	"Base.TannedLeather_LongCoat", 0.5,
	"Base.TannedLeather_LongCoat_O", 0.5,
	"Base.TannedLeather_Jacket", 0.5,
	"Base.TannedLeather_Jacket_O", 0.5,
	"Base.TannedLeather_Jacket_MidLength", 0.5,
	"Base.TannedLeather_Jacket_MidLength_O", 0.5,
	"Base.TannedLeather_TrenchCoat_Long_O", 0.5,
	"Base.TannedLeather_TrenchCoat_Short_O", 0.5,
	"Base.TannedLeather_LongestCoat_Winter", 0.5,
	"Base.TannedLeather_LongestCoat_Winter_O", 0.5,
	"Base.TannedLeather_LongerCoat_Winter", 0.5,
	"Base.TannedLeather_LongerCoat_Winter_O", 0.5,
	"Base.TannedLeather_WaistCoat", 0.5,
	"Base.TannedLeather_WaistCoat_O", 0.5,
	"Base.TMesh_TannedLeather_Pants", 0.5,
	"Base.TMesh_TannedLeather_LongShorts", 0.5,
	"Base.TMesh_TannedLeather_Shorts", 0.5,
	"Base.TMesh_TannedLeather_ShortShorts", 0.5,
	"Base.TMesh_TannedLeather_ShorterShorts", 0.5,
	"Base.TSkin_TannedLeather_Pants", 0.5,
	"Base.TannedLeather_Shorts_J", 0.5,
	"Base.TannedLeather_Shorts_Low", 0.5,
	"Base.TannedLeather_Skirt_Mesh_HW", 0.5,
	"Base.TannedLeather_Skirt_Mesh_LW", 0.5,
	"Base.TannedLeather_Skirt_Mesh_LerW", 0.5,
	"Base.TannedLeather_Skirt_MeshFrilled_HW", 0.5,
	"Base.TannedLeather_Skirt_MeshFrilled_LW", 0.5,
	"Base.TannedLeather_Skirt_MeshFrilled_LerW", 0.5,
	"Base.TannedLeather_SkirtMicro_Mesh", 0.5,
	"Base.TannedLeather_SkirtMicro_MeshFrilled", 0.5
)

BatchRuleInjection("WardrobeMan",
    "Base.Denim_Jacket_O", 0.5,
    "Base.TannedLeather_Jacket_O", 0.5,
    "Base.FurJacketShort_O", 0.5,
    "Base.Denim_Skirt_Short", 0.5,
    "Base.Denim_Skirt_Long", 0.5,
    "Base.FF_Boots_Common", 0.5,
    "Base.FF_Shoe_Common", 0.5,
	"Base.Cotton_Blouse", 0.5,
    "Base.Cotton_Blouse_V", 0.8,
    "Base.Cotton_Blouse_V_Cropped", 0.5,
    "Base.Cotton_Blouse_V_Cropped_Tiny", 0.5,
    "Base.Lumberjack_Shirt_10", 0.7,
    "Base.Lumberjack_Cropped_Shirt_10", 0.5,
    "Base.Lumberjack_Sleeveless_Shirt_10", 0.5,
    "Base.Denim_Shirt_10", 0.8,
    "Base.Denim_Sleeveless_Shirt_10", 0.7,
	"Base.Mesh_Denim_Pants",0.5,
	"Base.Mesh_Denim_PantsFlared",0.5,
	"Base.Mesh_Denim_PantsChaps",0.5,
	"Base.Mesh_Denim_LongShorts",0.5,
	"Base.Skin_Denim_Pants_J",0.5,
	"Base.Mesh_Denim_Shorts",0.5,
	"Base.Mesh_Denim_ShortShorts",0.5,
	"Base.Mesh_Denim_ShorterShorts",0.5,
	"Base.Skin_Denim_Shorts",0.5,
	"Base.Denim_Shorts_J",0.5,
	"Base.TMesh_TannedLeather_Pants",0.5,
	"Base.TMesh_TannedLeather_LongShorts",0.5,
	"Base.TMesh_TannedLeather_Shorts",0.5,
	"Base.TMesh_TannedLeather_ShortShorts",0.5,
	"Base.TMesh_TannedLeather_ShorterShorts",0.5,
	"Base.TSkin_TannedLeather_Pants",0.5,
	"Base.TannedLeather_Shorts_J",0.5,
	"Base.Denim_Skirt_Short", 0.5,
	"Base.Denim_Skirt_Short_LW", 0.5,
	"Base.Denim_Skirt_Longer", 0.5,
	"Base.Denim_LongCoat", 0.75,
	"Base.Denim_LongCoat_O", 0.75,
	"Base.Denim_LongCoatShort", 0.75,
	"Base.Denim_LongCoatShort_O", 0.75,
	"Base.Denim_LongCoatShort_Reinforced", 0.75,
	"Base.Denim_LongCoatShort_Reinforced_O", 0.75,
	"Base.Denim_LongCoatShortSleeveless", 0.75,
	"Base.Denim_LongCoatShortSleeveless_O", 0.75,
	"Base.Lumberjack_Shirt_10", 2,
    "Base.Lumberjack_Cropped_Shirt_10", 0.75,
    "Base.Lumberjack_Sleeveless_Shirt_10", 0.75,
	"Base.Denim_TrenchCoat_Long_O", 0.75,
	"Base.Denim_TrenchCoat_Short_O", 1
)

BatchRuleInjection("WardrobeMan",
	"Base.Denim_Skirt_Long", 0.5,
	"Base.Denim_Skirt_Mesh_HW", 0.5,
	"Base.Denim_Skirt_Mesh_LW", 0.5,
	"Base.Denim_SkirtPleated", 0.5,
	"Base.Denim_SkirtPleated_Frilled", 0.5,
	"Base.Mesh_Denim_Skirt_Longer", 0.5,
	"Base.Mesh_Denim_Pants", 0.5,
	"Base.Mesh_Denim_PantsFlared", 0.5,
	"Base.Mesh_Denim_PantsChaps", 0.5,
	"Base.Mesh_Denim_LongShorts", 0.5,
	"Base.Skin_Denim_Pants_High", 0.5,
	"Base.Skin_Denim_Pants_J", 0.5,
	"Base.Skin_Denim_Pants_Low", 0.5,
	"Base.Skin_Denim_Pants_Lower", 0.5,
	"Base.Skin_Denim_Pants_V", 0.5,
	"Base.Mesh_Denim_Shorts", 0.5,
	"Base.Mesh_Denim_ShortShorts", 0.5,
	"Base.Mesh_Denim_ShorterShorts", 0.5,
	"Base.Skin_Denim_Shorts", 0.5,
	"Base.Denim_Shorts_High", 0.5,
	"Base.Denim_Shorts_J", 0.5,
	"Base.Denim_Shorts_Low", 0.5,
	"Base.Denim_Shorts_Lower", 0.5,
	"Base.Denim_Shorts_V", 0.5,
	"Base.Denim_Overshirt", 0.5,
	"Base.Denim_Overshirt_O", 0.5,
	"Base.Denim_Shirt_10", 0.5,
	"Base.Denim_Shirt_15", 0.5,
	"Base.Denim_Shirt_20", 0.5,
	"Base.Denim_Shirt_25", 0.5,
	"Base.Denim_Sleeveless_Shirt_10", 0.5,
	"Base.Denim_Sleeveless_Shirt_15", 0.5,
	"Base.FurCoat_Fur", 0.5,
	"Base.FurJacketShort_O", 0.5,
	"Base.Belt_Generic", 0.5
)

BatchRuleInjection("WardrobeMan",
	"Base.BeltLarge_Star", 0.5,
	"Base.BeltLarge_Letters", 0.5,
	"Base.BeltLargeFur", 0.5,
	"Base.Accessory_Wild_Rag", 0.5,
	"Base.Accessory_Wild_Rag_Bandana", 0.5,
	"Base.Accessory_Wild_Rag_Scarf", 0.5,
	"Base.Accessory_Tie_Bolo", 0.5,
	"Base.Accessory_Tie_Bolo_Letters", 0.5,
	"Base.Accessory_Tie_Bolo_Star", 0.5,
	"Base.Accessory_Tie_Bolo_Sun", 0.5,
	"Base.Accessory_Tie_Bolo_Moon", 0.5,
	"Base.TannedLeather_Jacket_Cropped", 0.5,
	"Base.TannedLeather_LongestCoat", 0.5,
	"Base.TannedLeather_LongestCoat_O", 0.5,
	"Base.TannedLeather_LongerCoat", 0.5,
	"Base.TannedLeather_LongerCoat_O", 0.5,
	"Base.TannedLeather_LongCoat", 0.5,
	"Base.TannedLeather_LongCoat_O", 0.5,
	"Base.TannedLeather_Jacket", 0.5,
	"Base.TannedLeather_Jacket_O", 0.5,
	"Base.TannedLeather_Jacket_MidLength", 0.5,
	"Base.TannedLeather_Jacket_MidLength_O", 0.5,
	"Base.TannedLeather_TrenchCoat_Long_O", 0.5,
	"Base.TannedLeather_TrenchCoat_Short_O", 0.5,
	"Base.TannedLeather_LongestCoat_Winter", 0.5,
	"Base.TannedLeather_LongestCoat_Winter_O", 0.5,
	"Base.TannedLeather_LongerCoat_Winter", 0.5,
	"Base.TannedLeather_LongerCoat_Winter_O", 0.5
)

BatchRuleInjection("WardrobeMan",
	"Base.TannedLeather_Corset", 0.5,
	"Base.TannedLeather_Corset_UB", 0.5,
	"Base.TannedLeather_Corset_Strap", 0.5,
	"Base.TannedLeather_Corset_UB_Strap", 0.5,
	"Base.TannedLeather_WaistCoat", 0.5,
	"Base.TannedLeather_WaistCoat_O", 0.5,
	"Base.TMesh_TannedLeather_Pants", 0.5,
	"Base.TMesh_TannedLeather_LongShorts", 0.5,
	"Base.TMesh_TannedLeather_Shorts", 0.5,
	"Base.TMesh_TannedLeather_ShortShorts", 0.5,
	"Base.TMesh_TannedLeather_ShorterShorts", 0.5,
	"Base.TSkin_TannedLeather_Pants_High", 0.5,
	"Base.TSkin_TannedLeather_Pants", 0.5,
	"Base.TSkin_TannedLeather_Pants_Low", 0.5,
	"Base.TSkin_TannedLeather_Pants_Lower", 0.5,
	"Base.TSkin_TannedLeather_Pants_V", 0.5,
	"Base.TannedLeather_Shorts_High", 0.5,
	"Base.TannedLeather_Shorts_J", 0.5,
	"Base.TannedLeather_Shorts_Low", 0.5,
	"Base.TannedLeather_Shorts_Lower", 0.5,
	"Base.TannedLeather_Shorts_V", 0.5,
	"Base.TannedLeather_Skirt_Mesh_HW", 0.5,
	"Base.TannedLeather_Skirt_Mesh_LW", 0.5,
	"Base.TannedLeather_Skirt_Mesh_LerW", 0.5,
	"Base.TannedLeather_Skirt_MeshFrilled_HW", 0.5,
	"Base.TannedLeather_Skirt_MeshFrilled_LW", 0.5,
	"Base.TannedLeather_Skirt_MeshFrilled_LerW", 0.5,
	"Base.TannedLeather_SkirtMicro_Mesh", 0.5,
	"Base.Lumberjack_Shirt_10", 2,
    "Base.Lumberjack_Cropped_Shirt_10", 0.75,
    "Base.Lumberjack_Sleeveless_Shirt_10", 0.75,
	"Base.TannedLeather_SkirtMicro_MeshFrilled", 0.5
)

BatchRuleInjection("ClosetShelfGeneric",
    "Base.Cotton_Blouse", 0.5,
    "Base.Lumberjack_Shirt_10", 0.5,
    "Base.Denim_Shirt_10", 0.5,
    "Base.Denim_Shorts_J", 0.5,
    "Base.Denim_Skirt_Short", 0.5,
    "Base.FF_Shoe_Common", 0.5,
    "Base.FF_Shoe_Trainers", 0.5,
    "Base.Belt_Generic", 0.5,
	"Base.Belt_Generic",0.5,
	"Base.Belt_Cowboy",0.5,
	"Base.Belt_Gemstone",0.5,
	"Base.Belt_Gold",0.5,
	"Base.Belt_Silver",0.5,
	"Base.BeltLarge_Skulls",0.5,
	"Base.BeltLarge",0.5,
	"Base.BeltLarge_Gemstone",0.5,
	"Base.BeltLarge_Star",0.5,
	"Base.BeltLarge_Letters",0.5,
	"Base.BeltLargeFur",0.5,
	"Base.Accessory_Wild_Rag",0.5,
	"Base.Accessory_Wild_Rag_Bandana",0.5,
	"Base.Accessory_Wild_Rag_Scarf",0.5,
	"Base.Accessory_Tie_Bolo",0.5,
	"Base.Accessory_Tie_Bolo_Letters",0.5,
	"Base.Accessory_Tie_Bolo_Star",0.5,
	"Base.Accessory_Tie_Bolo_Sun",0.5,
	"Base.Accessory_Tie_Bolo_Moon",0.5,
	"Base.Denim_Jacket_Cropped", 0.75,
	"Base.Denim_Jacket", 0.75,
	"Base.Denim_Jacket_O", 0.75,
	"Base.Denim_JacketReinforced", 0.75,
	"Base.Denim_JacketReinforced_O", 0.75,
	"Base.Denim_JacketShort", 0.75,
	"Base.Denim_JacketShort_O", 0.75,
	"Base.Denim_VestJacket", 0.75,
	"Base.Denim_VestJacket_O", 0.75,
	"Base.Denim_VestJacketCropped", 0.75,
	"Base.Denim_VestJacketCropped_O", 0.75,
	"Base.Denim_VestJacketShort", 0.75,
	"Base.Denim_VestJacketShort_O", 0.75,
	"Base.Denim_LongCoat", 0.75,
	"Base.Denim_LongCoat_O", 0.75,
	"Base.Denim_LongCoatShort", 0.75,
	"Base.Denim_LongCoatShort_O", 0.75,
	"Base.Denim_LongCoatShort_Reinforced", 0.75,
	"Base.Denim_LongCoatShort_Reinforced_O", 0.75,
	"Base.Denim_LongCoatShortSleeveless", 0.75,
	"Base.Denim_LongCoatShortSleeveless_O", 0.75,
	"Base.Denim_TrenchCoat_Long_O", 0.75,
	"Base.Denim_TrenchCoat_Short_O", 0.75,
	"Base.TannedLeather_Jacket_Cropped", 0.75,
	"Base.TannedLeather_LongestCoat", 0.75,
	"Base.TannedLeather_LongestCoat_O", 0.75,
	"Base.TannedLeather_LongerCoat", 0.75,
	"Base.TannedLeather_LongerCoat_O", 0.75,
	"Base.TannedLeather_LongCoat", 0.75,
	"Base.TannedLeather_LongCoat_O", 0.75,
	"Base.TannedLeather_Jacket", 0.75,
	"Base.TannedLeather_Jacket_O", 0.75,
	"Base.TannedLeather_Jacket_MidLength", 0.75,
	"Base.TannedLeather_Jacket_MidLength_O", 0.75,
	"Base.TannedLeather_TrenchCoat_Long_O", 0.75,
	"Base.TannedLeather_TrenchCoat_Short_O", 0.75,
	"Base.TannedLeather_LongestCoat_Winter", 0.75,
	"Base.TannedLeather_LongestCoat_Winter_O", 0.75,
	"Base.TannedLeather_LongerCoat_Winter", 0.75,
	"Base.TannedLeather_LongerCoat_Winter_O", 0.75,
	"Base.Cotton_LongestCoat_VintageMil", 0.75,	
	"Base.Cotton_LongestCoat_VintageMil_O", 1
)

BatchRuleInjection("Locker",
    "Base.FF_Boots_HF_New", 0.5,
	"Base.FF_Boots_HF_New_Longest", 0.5,
	"Base.FF_Boots_HF_New_Longer", 0.5,
	"Base.FF_Boots_HF_New_Long", 0.5,
	"Base.FF_Shoe_Boots_Ankle_Platform", 0.5,
	"Base.FF_Boots_HighHeels", 0.5,
	"Base.FF_Shoe_Women", 0.5,
	"Base.FF_Shoe_Women_Platform", 0.5,
	"Base.FF_Shoe_Women_2", 0.5,
	"Base.FF_Shoe_Moccasin", 0.5,
	"Base.FF_Boots_UGG_DwarfHeel", 0.5,
	"Base.FF_Boots_UGG_Heel", 0.5,
	"Base.FF_Boots_UGG_ThighhighHeel", 0.5,
	"Base.FF_Boots_UGG_KneehighHeel", 0.5,
	"Base.FF_Boots_UGG", 0.5,
	"Base.FF_Boots_UGG_Thighhigh", 0.5,
	"Base.FF_Boots_UGG_Kneehigh", 0.5,
	"Base.FF_Boots_Leather", 0.5,
	"Base.FF_Boots_Leather_Short", 0.5,
	"Base.FF_Boots_Cowboy", 0.5,
	"Base.FF_Boots_Cowboy_Plain", 0.5,
	"Base.FF_Shoe_Boots_Ankle", 0.5,
	"Base.FF_Shoe_Boots_Ankle_Steel", 0.5,
	"Base.FF_Boots_Common", 0.5,
	"Base.FF_Shoe_Common", 0.5,
	"Base.FF_Shoe_Trainers", 0.5,
	"Base.FF_Shoe_TrainersBlack", 0.5,
	"Base.FF_Shoe_TrainersWhite", 0.5,
	"Base.FF_Boots_Platform_Thighhigh", 0.5,
	"Base.FF_Boots_Platform_Kneehigher", 0.5,
	"Base.FF_Boots_Platform_Kneehigh", 0.5,
	"Base.FF_Boots_Platform_Ankle", 0.5,
	"Base.FF_Boots_Platform_AnkleLow", 0.5,
	"Base.FF_Boots_PlatformPunk_Thighhigh", 0.5,
	"Base.FF_Boots_PlatformPunk_Kneehigher", 0.5,
	"Base.FF_Boots_PlatformPunk_Kneehigh", 0.5,
	"Base.FF_Boots_Pointy_AnkleLow", 0.5,
	"Base.FF_Boots_Pointy_Ankle", 0.5,
	"Base.FF_Boots_Pointy_Kneehigh", 0.5,
	"Base.FF_Boots_PointySkull_AnkleLow", 0.5,
	"Base.FF_Boots_PointySkull_Kneehigh", 0.5,
	"Base.FF_BootsRE_Leather_DwarfHeel", 0.5,
	"Base.FF_BootsRE_Leather_Heel", 0.5,
	"Base.FF_BootsRE_Leather_ThighhighHeel", 0.5,
	"Base.FF_BootsRE_Leather_KneehighHeel", 0.5,
	"Base.FF_Boots_Military_Thighhigh", 0.5,
	"Base.FF_Boots_Military_Kneehigher", 0.5,
	"Base.FF_Boots_Military_Kneehigh", 0.5,
	"Base.FF_Boots_Military_Ankle", 0.5,
	"Base.Belt_Generic",0.5,
	"Base.Belt_Cowboy",0.5,
	"Base.Belt_Gemstone",0.5,
	"Base.Belt_Gold",0.5,
	"Base.Belt_Silver",0.5,
	"Base.BeltLarge_Skulls",0.5,
	"Base.BeltLarge",0.5,
	"Base.BeltLarge_Gemstone",0.5,
	"Base.BeltLarge_Star",0.5,
	"Base.BeltLarge_Letters",0.5,
	"Base.BeltLargeFur",0.5,
	"Base.Accessory_Wild_Rag",0.5,
	"Base.Accessory_Wild_Rag_Bandana",0.5,
	"Base.Accessory_Wild_Rag_Scarf",0.5,
	"Base.Accessory_Tie_Bolo",0.5,
	"Base.Accessory_Tie_Bolo_Letters",0.5,
	"Base.Accessory_Tie_Bolo_Star",0.5,
	"Base.Accessory_Tie_Bolo_Sun",0.5,
	"Base.Accessory_Tie_Bolo_Moon",0.5
)

BatchRuleInjection("Locker",
	"Base.Denim_Jacket_Cropped", 0.75,
	"Base.Denim_Jacket", 0.75,
	"Base.Denim_Jacket_O", 0.75,
	"Base.Denim_JacketReinforced", 2,
	"Base.Denim_JacketReinforced_O", 2,
	"Base.Denim_JacketShort", 0.75,
	"Base.Denim_JacketShort_O", 0.75,
	"Base.Denim_VestJacket", 0.75,
	"Base.Denim_VestJacket_O", 0.75,
	"Base.Denim_VestJacketCropped", 0.75,
	"Base.Denim_VestJacketCropped_O", 0.75,
	"Base.Denim_VestJacketShort", 0.75,
	"Base.Denim_VestJacketShort_O", 0.75,
	"Base.Denim_LongCoat", 0.75,
	"Base.Denim_LongCoat_O", 0.75,
	"Base.Denim_LongCoatShort", 0.75,
	"Base.Denim_LongCoatShort_O", 0.75,
	"Base.Denim_LongCoatShort_Reinforced", 0.75,
	"Base.Denim_LongCoatShort_Reinforced_O", 0.75,
	"Base.Denim_LongCoatShortSleeveless", 0.75,
	"Base.Denim_LongCoatShortSleeveless_O", 0.75,
	"Base.Denim_TrenchCoat_Long_O", 0.75,
	"Base.Denim_TrenchCoat_Short_O", 0.75,
	"Base.TannedLeather_Jacket_Cropped", 0.75,
	"Base.TannedLeather_LongestCoat", 0.75,
	"Base.TannedLeather_LongestCoat_O", 0.75,
	"Base.TannedLeather_LongerCoat", 0.75,
	"Base.TannedLeather_LongerCoat_O", 0.75,
	"Base.TannedLeather_LongCoat", 0.75,
	"Base.TannedLeather_LongCoat_O", 0.75,
	"Base.TannedLeather_Jacket", 0.75,
	"Base.TannedLeather_Jacket_O", 0.75,
	"Base.TannedLeather_Jacket_MidLength", 0.75,
	"Base.TannedLeather_Jacket_MidLength_O", 0.75,
	"Base.TannedLeather_TrenchCoat_Long_O", 0.75,
	"Base.TannedLeather_TrenchCoat_Short_O", 0.75,
	"Base.TannedLeather_LongestCoat_Winter", 0.75,
	"Base.TannedLeather_LongestCoat_Winter_O", 0.75,
	"Base.TannedLeather_LongerCoat_Winter", 0.75,
	"Base.TannedLeather_LongerCoat_Winter_O", 0.75,
	"Base.Cotton_LongestCoat_VintageMil", 0.75,	
	"Base.Cotton_LongestCoat_VintageMil_O", 1
)

BatchRuleInjection("SchoolLockers",
	"Base.Denim_Jacket_Cropped", 0.75,
	"Base.Denim_Jacket", 0.75,
	"Base.Denim_Jacket_O", 0.75,
	"Base.Denim_JacketReinforced", 2,
	"Base.Denim_JacketReinforced_O", 2,
	"Base.Denim_JacketShort", 0.75,
	"Base.Denim_JacketShort_O", 0.75,
	"Base.Denim_VestJacket", 0.75,
	"Base.Denim_VestJacket_O", 0.75,
	"Base.Denim_VestJacketCropped", 0.75,
	"Base.Denim_VestJacketCropped_O", 0.75,
	"Base.Denim_VestJacketShort", 0.75,
	"Base.Denim_VestJacketShort_O", 0.75,
	"Base.Denim_LongCoat", 0.75,
	"Base.Denim_LongCoat_O", 0.75,
	"Base.Denim_LongCoatShort", 0.75,
	"Base.Denim_LongCoatShort_O", 0.75,
	"Base.Denim_LongCoatShort_Reinforced", 0.75,
	"Base.Denim_LongCoatShort_Reinforced_O", 0.75,
	"Base.Denim_LongCoatShortSleeveless", 0.75,
	"Base.Denim_LongCoatShortSleeveless_O", 0.75,
	"Base.Denim_TrenchCoat_Long_O", 0.75,
	"Base.Denim_TrenchCoat_Short_O", 0.75,
	"Base.TannedLeather_Jacket_Cropped", 0.75,
	"Base.TannedLeather_LongestCoat", 0.75,
	"Base.TannedLeather_LongestCoat_O", 0.75,
	"Base.TannedLeather_LongerCoat", 0.75,
	"Base.TannedLeather_LongerCoat_O", 0.75,
	"Base.TannedLeather_LongCoat", 0.75,
	"Base.TannedLeather_LongCoat_O", 0.75,
	"Base.TannedLeather_Jacket", 0.75,
	"Base.TannedLeather_Jacket_O", 0.75,
	"Base.TannedLeather_Jacket_MidLength", 0.75,
	"Base.TannedLeather_Jacket_MidLength_O", 0.75,
	"Base.TannedLeather_TrenchCoat_Long_O", 0.75,
	"Base.TannedLeather_TrenchCoat_Short_O", 0.75,
	"Base.TannedLeather_LongestCoat_Winter", 0.75,
	"Base.TannedLeather_LongestCoat_Winter_O", 0.75,
	"Base.TannedLeather_LongerCoat_Winter", 0.75,
	"Base.TannedLeather_LongerCoat_Winter_O", 0.75,
	"Base.Cotton_LongestCoat_VintageMil", 0.75,	
	"Base.Cotton_LongestCoat_VintageMil_O", 1
)

BatchRuleInjection("FactoryLockers",
	"Base.Denim_Jacket_Cropped", 0.75,
	"Base.Denim_Jacket", 0.75,
	"Base.Denim_Jacket_O", 0.75,
	"Base.Denim_JacketReinforced", 2,
	"Base.Denim_JacketReinforced_O", 2,
	"Base.Denim_JacketShort", 0.75,
	"Base.Denim_JacketShort_O", 0.75,
	"Base.Denim_VestJacket", 0.75,
	"Base.Denim_VestJacket_O", 0.75,
	"Base.Denim_VestJacketCropped", 0.75,
	"Base.Denim_VestJacketCropped_O", 0.75,
	"Base.Denim_VestJacketShort", 0.75,
	"Base.Denim_VestJacketShort_O", 0.75,
	"Base.Denim_LongCoat", 0.75,
	"Base.Denim_LongCoat_O", 0.75,
	"Base.Denim_LongCoatShort", 0.75,
	"Base.Denim_LongCoatShort_O", 0.75,
	"Base.Denim_LongCoatShort_Reinforced", 0.75,
	"Base.Denim_LongCoatShort_Reinforced_O", 0.75,
	"Base.Denim_LongCoatShortSleeveless", 0.75,
	"Base.Denim_LongCoatShortSleeveless_O", 0.75,
	"Base.Denim_TrenchCoat_Long_O", 0.75,
	"Base.Denim_TrenchCoat_Short_O", 0.75,
	"Base.TannedLeather_Jacket_Cropped", 0.75,
	"Base.TannedLeather_LongestCoat", 0.75,
	"Base.TannedLeather_LongestCoat_O", 0.75,
	"Base.TannedLeather_LongerCoat", 0.75,
	"Base.TannedLeather_LongerCoat_O", 0.75,
	"Base.TannedLeather_LongCoat", 0.75,
	"Base.TannedLeather_LongCoat_O", 0.75,
	"Base.TannedLeather_Jacket", 0.75,
	"Base.TannedLeather_Jacket_O", 0.75,
	"Base.TannedLeather_Jacket_MidLength", 0.75,
	"Base.TannedLeather_Jacket_MidLength_O", 0.75,
	"Base.TannedLeather_TrenchCoat_Long_O", 0.75,
	"Base.TannedLeather_TrenchCoat_Short_O", 0.75,
	"Base.TannedLeather_LongestCoat_Winter", 0.75,
	"Base.TannedLeather_LongestCoat_Winter_O", 0.75,
	"Base.TannedLeather_LongerCoat_Winter", 0.75,
	"Base.TannedLeather_LongerCoat_Winter_O", 0.75,
	"Base.Cotton_LongestCoat_VintageMil", 0.75,	
	"Base.Cotton_LongestCoat_VintageMil_O", 0.75,
    "Base.Lumberjack_Shirt_10", 4,
    "Base.Denim_Shirt_10", 3,
    "Base.Denim_Shorts_J", 0.5,
    "Base.Denim_Skirt_Short", 0.5
)
	
BatchRuleInjection("LivingRoomShelf",
    "Base.FF_Boots_HF_New", 0.05,
    "Base.FF_Boots_HF_New_Longest", 0.05,
    "Base.FF_Boots_HF_New_Longer", 0.05,
    "Base.FF_Boots_HF_New_Long", 0.05,
    "Base.FF_Boots_Leather", 0.05,
    "Base.FF_Boots_Leather_Short", 0.05,
    "Base.FF_Boots_Cowboy", 0.05,
    "Base.FF_Boots_Cowboy_Plain", 0.05,
    "Base.FF_Shoe_Boots_Ankle", 0.05,
    "Base.FF_Shoe_Boots_Ankle_Steel", 0.05,
    "Base.FF_Boots_Common", 0.05,
    "Base.FF_Boots_Platform_Thighhigh", 0.05,
    "Base.FF_Boots_Platform_Kneehigher", 0.05,
    "Base.FF_Boots_Platform_Kneehigh", 0.05,
    "Base.FF_Boots_Platform_Ankle", 0.05,
    "Base.FF_Boots_Platform_AnkleLow", 0.05,
    "Base.FF_Boots_Pointy_AnkleLow", 0.05,
    "Base.FF_Boots_Pointy_Ankle", 0.05,
    "Base.FF_Boots_Pointy_Kneehigh", 0.05,
	"Base.FF_Boots_HF_New", 0.05,
	"Base.FF_Boots_HF_New_Longest", 0.05,
	"Base.FF_Boots_HF_New_Longer", 0.05,
	"Base.FF_Boots_HF_New_Long", 0.05,
	"Base.FF_Shoe_Boots_Ankle_Platform", 0.05,
	"Base.FF_Boots_HighHeels", 0.05,
	"Base.FF_Shoe_Women", 0.05,
	"Base.FF_Shoe_Women_Platform", 0.05,
	"Base.FF_Shoe_Women_.5", 0.05,
	"Base.FF_Shoe_Moccasin", 0.05,
	"Base.FF_Boots_UGG_DwarfHeel", 0.05,
	"Base.FF_Boots_UGG_Heel", 0.05,
	"Base.FF_Boots_UGG_ThighhighHeel", 0.05,
	"Base.FF_Boots_UGG_KneehighHeel", 0.05,
	"Base.FF_Boots_UGG", 0.05,
	"Base.FF_Boots_UGG_Thighhigh", 0.05,
	"Base.FF_Boots_UGG_Kneehigh", 0.05,
	"Base.FF_Boots_Leather", 0.05,
	"Base.FF_Boots_Leather_Short", 0.05,
	"Base.FF_Boots_Cowboy", 0.05,
	"Base.FF_Boots_Cowboy_Plain", 0.05,
	"Base.FF_Shoe_Boots_Ankle", 0.05,
	"Base.FF_Shoe_Boots_Ankle_Steel", 0.05,
	"Base.FF_Boots_Common", 0.05,
	"Base.FF_Shoe_Common", 0.05,
	"Base.FF_Shoe_Trainers", 0.05,
	"Base.FF_Shoe_TrainersBlack", 0.05,
	"Base.FF_Shoe_TrainersWhite", 0.05,
	"Base.FF_Boots_Platform_Thighhigh", 0.05,
	"Base.FF_Boots_Platform_Kneehigher", 0.05,
	"Base.FF_Boots_Platform_Kneehigh", 0.05,
	"Base.FF_Boots_Platform_Ankle", 0.05,
	"Base.FF_Boots_Platform_AnkleLow", 0.05,
	"Base.FF_Boots_PlatformPunk_Thighhigh", 0.05,
	"Base.FF_Boots_PlatformPunk_Kneehigher", 0.05,
	"Base.FF_Boots_PlatformPunk_Kneehigh", 0.05,
	"Base.FF_Boots_Pointy_AnkleLow", 0.05,
	"Base.FF_Boots_Pointy_Ankle", 0.05,
	"Base.FF_Boots_Pointy_Kneehigh", 0.05,
	"Base.FF_Boots_PointySkull_AnkleLow", 0.05,
	"Base.FF_Boots_PointySkull_Kneehigh", 0.05,
	"Base.FF_BootsRE_Leather_DwarfHeel", 0.05,
	"Base.FF_BootsRE_Leather_Heel", 0.05,
	"Base.FF_BootsRE_Leather_ThighhighHeel", 0.05,
	"Base.FF_BootsRE_Leather_KneehighHeel", 0.05,
	"Base.FF_Boots_Military_Thighhigh", 0.05,
	"Base.FF_Boots_Military_Kneehigher", 0.05,
	"Base.FF_Boots_Military_Kneehigh", 0.05,
	"Base.FF_Boots_Military_Ankle", 0.05
)

BatchRuleInjection("CrateClothesRandom",
    "Base.FF_Boots_HF_New", 2,
    "Base.FF_Boots_HF_New_Longest", 2,
    "Base.FF_Boots_HF_New_Longer", 2,
    "Base.FF_Boots_HF_New_Long", 2,
    "Base.FF_Boots_Leather", 2,
    "Base.FF_Boots_Leather_Short", 2,
    "Base.FF_Boots_Cowboy", 2,
    "Base.FF_Boots_Cowboy_Plain", 2,
    "Base.FF_Shoe_Boots_Ankle", 2,
    "Base.FF_Shoe_Boots_Ankle_Steel", 2,
    "Base.FF_Boots_Common", 2,
    "Base.FF_Boots_Platform_Thighhigh", 2,
    "Base.FF_Boots_Platform_Kneehigher", 2,
    "Base.FF_Boots_Platform_Kneehigh", 2,
    "Base.FF_Boots_Platform_Ankle", 2,
    "Base.FF_Boots_Platform_AnkleLow", 2,
    "Base.FF_Boots_Pointy_AnkleLow", 2,
    "Base.FF_Boots_Pointy_Ankle", 2,
    "Base.FF_Boots_Pointy_Kneehigh", 2,
	"Base.FF_Boots_HF_New", 2,
	"Base.FF_Boots_HF_New_Longest", 2,
	"Base.FF_Boots_HF_New_Longer", 2,
	"Base.FF_Boots_HF_New_Long", 2,
	"Base.FF_Shoe_Boots_Ankle_Platform", 2,
	"Base.FF_Boots_HighHeels", 2,
	"Base.FF_Shoe_Women", 2,
	"Base.FF_Shoe_Women_Platform", 2,
	"Base.FF_Shoe_Women_2", 2,
	"Base.FF_Shoe_Moccasin", 2,
	"Base.FF_Boots_UGG_DwarfHeel", 2,
	"Base.FF_Boots_UGG_Heel", 2,
	"Base.FF_Boots_UGG_ThighhighHeel", 2,
	"Base.FF_Boots_UGG_KneehighHeel", 2,
	"Base.FF_Boots_UGG", 2,
	"Base.FF_Boots_UGG_Thighhigh", 2,
	"Base.FF_Boots_UGG_Kneehigh", 2,
	"Base.FF_Boots_Leather", 2,
	"Base.FF_Boots_Leather_Short", 2,
	"Base.FF_Boots_Cowboy", 2,
	"Base.FF_Boots_Cowboy_Plain", 2,
	"Base.FF_Shoe_Boots_Ankle", 2,
	"Base.FF_Shoe_Boots_Ankle_Steel", 2,
	"Base.FF_Boots_Common", 2,
	"Base.FF_Shoe_Common", 2,
	"Base.FF_Shoe_Trainers", 2,
	"Base.FF_Shoe_TrainersBlack", 2,
	"Base.FF_Shoe_TrainersWhite", 2,
	"Base.FF_Boots_Platform_Thighhigh", 2,
	"Base.FF_Boots_Platform_Kneehigher", 2,
	"Base.FF_Boots_Platform_Kneehigh", 2,
	"Base.FF_Boots_Platform_Ankle", 2,
	"Base.FF_Boots_Platform_AnkleLow", 2,
	"Base.FF_Boots_PlatformPunk_Thighhigh", 2,
	"Base.FF_Boots_PlatformPunk_Kneehigher", 2,
	"Base.FF_Boots_PlatformPunk_Kneehigh", 2,
	"Base.FF_Boots_Pointy_AnkleLow", 2,
	"Base.FF_Boots_Pointy_Ankle", 2,
	"Base.FF_Boots_Pointy_Kneehigh", 2,
	"Base.FF_Boots_PointySkull_AnkleLow", 2,
	"Base.FF_Boots_PointySkull_Kneehigh", 2,
	"Base.FF_BootsRE_Leather_DwarfHeel", 2,
	"Base.FF_BootsRE_Leather_Heel", 2,
	"Base.FF_BootsRE_Leather_ThighhighHeel", 2,
	"Base.FF_BootsRE_Leather_KneehighHeel", 2,
	"Base.FF_Boots_Military_Thighhigh", 2,
	"Base.FF_Boots_Military_Kneehigher", 2,
	"Base.FF_Boots_Military_Kneehigh", 2,
	"Base.FF_Boots_Military_Ankle", 2
)

BatchRuleInjection("CrateClothesRandom",
	"Base.Cotton_LongestCoat_VintageMil", 0.5,	
	"Base.Cotton_LongestCoat_VintageMil_O", 0.5,	
	"Base.Cotton_Blouse", 0.5,
	"Base.Cotton_Blouse_V", 0.5,
	"Base.Cotton_Blouse_V_Cropped", 0.5,	
	"Base.Cotton_Blouse_V_Cropped_Tiny", 0.5,
	"Base.Lumberjack_Shirt_10", 0.5,
	"Base.Lumberjack_Shirt_11", 0.5,
	"Base.Lumberjack_Shirt_12", 0.5,
	"Base.Lumberjack_Shirt_15", 0.5,
	"Base.Lumberjack_Shirt_20", 0.5,
	"Base.Lumberjack_Shirt_21", 0.5,
	"Base.Lumberjack_Shirt_22", 0.5,
	"Base.Lumberjack_Shirt_25", 0.5,
	"Base.Lumberjack_Cropped_Shirt_10", 0.5,
	"Base.Lumberjack_Cropped_Shirt_11", 0.5,
	"Base.Lumberjack_Cropped_Shirt_12", 0.5,
	"Base.Lumberjack_Cropped_Shirt_15", 0.5,
	"Base.Lumberjack_Cropped_Shirt_20", 0.5,
	"Base.Lumberjack_Cropped_Shirt_21", 0.5,
	"Base.Lumberjack_Cropped_Shirt_22", 0.5,
	"Base.Lumberjack_Cropped_Shirt_25", 0.5,
	"Base.Lumberjack_Sleeveless_Shirt_10", 0.5,
	"Base.Lumberjack_Sleeveless_Shirt_11", 0.5,
	"Base.Lumberjack_Sleeveless_Shirt_12", 0.5,
	"Base.Lumberjack_Sleeveless_Shirt_15", 0.5,
	"Base.Denim_Bandeau", 0.5,
	"Base.Denim_Bandeau_Tiny", 0.5,
	"Base.Denim_Top", 0.5
)

BatchRuleInjection("CrateClothesRandom",
	"Base.Denim_CropTop", 0.5,
	"Base.Denim_Skirt_Short", 0.5,
	"Base.Denim_Skirt_Short_LW", 0.5,
	"Base.Denim_Skirt_Longer", 0.5,
	"Base.Denim_Skirt_Long", 0.5,
	"Base.Denim_Skirt_Mesh_HW", 0.5,
	"Base.Denim_Skirt_Mesh_LW", 0.5,
	"Base.Denim_SkirtPleated", 0.5,
	"Base.Denim_SkirtPleated_Frilled", 0.5,
	"Base.Mesh_Denim_Skirt_Longer", 0.5,
	"Base.Denim_Jacket_Cropped", 0.5,
	"Base.Denim_Jacket", 0.5,
	"Base.Denim_Jacket_O", 0.5,
	"Base.Denim_JacketReinforced", 0.5,
	"Base.Denim_JacketReinforced_O", 0.5,
	"Base.Denim_JacketShort", 0.5,
	"Base.Denim_JacketShort_O", 0.5,
	"Base.Denim_VestJacket", 0.5,
	"Base.Denim_VestJacket_O", 0.5,
	"Base.Denim_VestJacketCropped", 0.5,
	"Base.Denim_VestJacketCropped_O", 0.5,
	"Base.Denim_VestJacketShort", 0.5,
	"Base.Denim_VestJacketShort_O", 0.5,
	"Base.Denim_LongCoat", 0.5,
	"Base.Denim_LongCoat_O", 0.5,
	"Base.Denim_LongCoatShort", 0.5,
	"Base.Denim_LongCoatShort_O", 0.5,
	"Base.Denim_LongCoatShort_Reinforced", 0.5,
	"Base.Denim_LongCoatShort_Reinforced_O", 0.5,
	"Base.Denim_LongCoatShortSleeveless", 0.5,
	"Base.Denim_LongCoatShortSleeveless_O", 0.5,
	"Base.Denim_TrenchCoat_Long_O", 0.5,
	"Base.Denim_TrenchCoat_Short_O", 0.5,
	"Base.Mesh_Denim_Pants", 0.5,
	"Base.Mesh_Denim_PantsFlared", 0.5,
	"Base.Mesh_Denim_PantsChaps", 0.5,
	"Base.Mesh_Denim_LongShorts", 0.5,
	"Base.Skin_Denim_Pants_High", 0.5,
	"Base.Skin_Denim_Pants_J", 0.5,
	"Base.Skin_Denim_Pants_Low", 0.5,
	"Base.Skin_Denim_Pants_Lower", 0.5,
	"Base.Skin_Denim_Pants_V", 0.5,
	"Base.Mesh_Denim_Shorts", 0.5,
	"Base.Mesh_Denim_ShortShorts", 0.5,
	"Base.Mesh_Denim_ShorterShorts", 0.5,
	"Base.Skin_Denim_Shorts", 0.5,
	"Base.Denim_Shorts_High", 0.5,
	"Base.Denim_Shorts_J", 0.5,
	"Base.Denim_Shorts_Low", 0.5,
	"Base.Denim_Shorts_Lower", 0.5,
	"Base.Denim_Shorts_V", 0.5,
	"Base.Denim_Overshirt", 0.5,
	"Base.Denim_Overshirt_O", 0.5,
	"Base.Denim_Shirt_10", 0.5,
	"Base.Denim_Shirt_11", 0.5,
	"Base.Denim_Shirt_12", 0.5,
	"Base.Denim_Shirt_15", 0.5,
	"Base.Denim_Shirt_20", 0.5,
	"Base.Denim_Shirt_21", 0.5,
	"Base.Denim_Shirt_22", 0.5,
	"Base.Denim_Shirt_25", 0.5,
	"Base.Denim_Sleeveless_Shirt_10", 0.5,
	"Base.Denim_Sleeveless_Shirt_11", 0.5
)

BatchRuleInjection("CrateClothesRandom",
	"Base.Denim_Sleeveless_Shirt_12", 0.5,
	"Base.Denim_Sleeveless_Shirt_15", 0.5,
	"Base.FurCoat_Fur", 0.5,
	"Base.FurJacketShort", 0.5,
	"Base.FurJacketShort_O", 0.5,
	"Base.Belt_Generic", 0.5,
	"Base.Belt_Cowboy", 0.5,
	"Base.Belt_Gemstone", 0.5,
	"Base.Belt_Gold", 0.5,
	"Base.Belt_Silver", 0.5,
	"Base.BeltLarge_Skulls", 0.5,
	"Base.BeltLarge", 0.5,
	"Base.BeltLarge_Gemstone", 0.5,
	"Base.BeltLarge_Star", 0.5,
	"Base.BeltLarge_Letters", 0.5,
	"Base.BeltLargeFur", 0.5,
	"Base.Accessory_Wild_Rag", 0.5,
	"Base.Accessory_Wild_Rag_Bandana", 0.5,
	"Base.Accessory_Wild_Rag_Scarf", 0.5,
	"Base.Accessory_Tie_Bolo_NoCollar", 0.5,
	"Base.Accessory_Tie_Bolo_Letters_NoCollar", 0.5,
	"Base.Accessory_Tie_Bolo_Star_NoCollar", 0.5,
	"Base.Accessory_Tie_Bolo_Sun_NoCollar", 0.5,
	"Base.Accessory_Tie_Bolo_Moon_NoCollar", 0.5,
	"Base.Accessory_Tie_Bolo", 0.5,
	"Base.Accessory_Tie_Bolo_Letters", 0.5,
	"Base.Accessory_Tie_Bolo_Star", 0.5,
	"Base.Accessory_Tie_Bolo_Sun", 0.5,
	"Base.Accessory_Tie_Bolo_Moon", 0.5,
	"Base.FF_Boots_HF_New", 0.5,
	"Base.FF_Boots_HF_New_Longest", 0.5,
	"Base.FF_Boots_HF_New_Longer", 0.5,
	"Base.FF_Boots_HF_New_Long", 0.5,
	"Base.FF_Shoe_Boots_Ankle_Platform", 0.5,
	"Base.FF_Boots_HighHeels", 0.5,
	"Base.FF_Shoe_Women", 0.5,
	"Base.FF_Shoe_Women_Platform", 0.5,
	"Base.FF_Shoe_Women_2", 0.5,
	"Base.FF_Shoe_Moccasin", 0.5
)

BatchRuleInjection("CrateClothesRandom",
	"Base.FF_Boots_UGG_DwarfHeel", 0.5,
	"Base.FF_Boots_UGG_Heel", 0.5,
	"Base.FF_Boots_UGG_ThighhighHeel", 0.5,
	"Base.FF_Boots_UGG_KneehighHeel", 0.5,
	"Base.FF_Boots_UGG", 0.5,
	"Base.FF_Boots_UGG_Thighhigh", 0.5,
	"Base.FF_Boots_UGG_Kneehigh", 0.5,
	"Base.FF_Boots_Leather", 0.5,
	"Base.FF_Boots_Leather_Short", 0.5,
	"Base.FF_Boots_Cowboy", 0.5,
	"Base.FF_Boots_Cowboy_Plain", 0.5,
	"Base.FF_Shoe_Boots_Ankle", 0.5,
	"Base.FF_Shoe_Boots_Ankle_Steel", 0.5,
	"Base.FF_Boots_Common", 0.5,
	"Base.FF_Shoe_Common", 0.5,
	"Base.FF_Shoe_Trainers", 0.5,
	"Base.FF_Shoe_TrainersBlack", 0.5,
	"Base.FF_Shoe_TrainersWhite", 0.5,
	"Base.FF_Boots_Platform_Thighhigh", 0.5,
	"Base.FF_Boots_Platform_Kneehigher", 0.5,
	"Base.FF_Boots_Platform_Kneehigh", 0.5,
	"Base.FF_Boots_Platform_Ankle", 0.5,
	"Base.FF_Boots_Platform_AnkleLow", 0.5,
	"Base.FF_Boots_PlatformPunk_Thighhigh", 0.5,
	"Base.FF_Boots_PlatformPunk_Kneehigher", 0.5,
	"Base.FF_Boots_PlatformPunk_Kneehigh", 0.5,
	"Base.FF_Boots_Pointy_AnkleLow", 0.5,
	"Base.FF_Boots_Pointy_Ankle", 0.5,
	"Base.FF_Boots_Pointy_Kneehigh", 0.5,
	"Base.FF_Boots_PointySkull_AnkleLow", 0.5,
	"Base.FF_Boots_PointySkull_Kneehigh", 0.5,
	"Base.FF_BootsRE_Leather_DwarfHeel", 0.5,
	"Base.FF_BootsRE_Leather_Heel", 0.5,
	"Base.FF_BootsRE_Leather_ThighhighHeel", 0.5,
	"Base.FF_BootsRE_Leather_KneehighHeel", 0.5,
	"Base.FF_Boots_Military_Thighhigh", 0.5,
	"Base.FF_Boots_Military_Kneehigher", 0.5,
	"Base.FF_Boots_Military_Kneehigh", 0.5,
	"Base.FF_Boots_Military_Ankle", 0.5,
	"Base.TannedLeather_Jacket_Cropped", 0.5,
	"Base.TannedLeather_LongestCoat", 0.5,
	"Base.TannedLeather_LongestCoat_O", 0.5,
	"Base.TannedLeather_LongerCoat", 0.5,
	"Base.TannedLeather_LongerCoat_O", 0.5
)

BatchRuleInjection("CrateClothesRandom",
	"Base.TannedLeather_LongCoat", 0.5,
	"Base.TannedLeather_LongCoat_O", 0.5,
	"Base.TannedLeather_Jacket", 0.5,
	"Base.TannedLeather_Jacket_O", 0.5,
	"Base.TannedLeather_Jacket_MidLength", 0.5,
	"Base.TannedLeather_Jacket_MidLength_O", 0.5,
	"Base.TannedLeather_TrenchCoat_Long_O", 0.5,
	"Base.TannedLeather_TrenchCoat_Short_O", 0.5,
	"Base.TannedLeather_LongestCoat_Winter", 0.5,
	"Base.TannedLeather_LongestCoat_Winter_O", 0.5,
	"Base.TannedLeather_LongerCoat_Winter", 0.5,
	"Base.TannedLeather_LongerCoat_Winter_O", 0.5,
	"Base.TannedLeather_Top", 0.5,
	"Base.TannedLeather_TopSkimpy", 0.5,
	"Base.TannedLeather_CropTop", 0.5,
	"Base.TannedLeather_Bandeau", 0.5,
	"Base.TannedLeather_Bandeau_Tiny", 0.5,
	"Base.TannedLeather_Corset", 0.5,
	"Base.TannedLeather_Corset_OuterLayer", 0.5,
	"Base.TannedLeather_Corset_UB", 0.5,
	"Base.TannedLeather_Corset_UB_OuterLayer", 0.5,
	"Base.TannedLeather_Corset_Strap", 0.5,
	"Base.TannedLeather_Corset_Strap_OuterLayer", 0.5,
	"Base.TannedLeather_Corset_UB_Strap", 0.5,
	"Base.TannedLeather_Corset_UB_Strap_OuterLayer", 0.5,
	"Base.TannedLeather_WaistCoat", 0.5,
	"Base.TannedLeather_WaistCoat_O", 0.5,
	"Base.TMesh_TannedLeather_Pants", 0.5,
	"Base.TMesh_TannedLeather_LongShorts", 0.5,
	"Base.TMesh_TannedLeather_Shorts", 0.5,
	"Base.TMesh_TannedLeather_ShortShorts", 0.5,
	"Base.TMesh_TannedLeather_ShorterShorts", 0.5,
	"Base.TannedLeather_Leotard", 0.5,
	"Base.TannedLeather_Leotard_MC", 0.5,
	"Base.TannedLeather_Leotard_HC", 0.5,
	"Base.TannedLeather_LeotardUB", 0.5,
	"Base.TannedLeather_LeotardUB_MC", 0.5,
	"Base.TannedLeather_LeotardUB_HC", 0.5,
	"Base.TSkin_TannedLeather_Pants_High", 0.5,
	"Base.TSkin_TannedLeather_Pants", 0.5
)

BatchRuleInjection("CrateClothesRandom",
	"Base.TSkin_TannedLeather_Pants_Low", 0.5,
	"Base.TSkin_TannedLeather_Pants_Lower", 0.5,
	"Base.TSkin_TannedLeather_Pants_V", 0.5,
	"Base.TannedLeather_Shorts_High", 0.5,
	"Base.TannedLeather_Shorts_J", 0.5,
	"Base.TannedLeather_Shorts_Low", 0.5,
	"Base.TannedLeather_Shorts_Lower", 0.5,
	"Base.TannedLeather_Shorts_V", 0.5,
	"Base.TannedLeather_Skirt_Mesh_HW", 0.5,
	"Base.TannedLeather_Skirt_Mesh_LW", 0.5,
	"Base.TannedLeather_Skirt_Mesh_LerW", 0.5,
	"Base.TannedLeather_Skirt_MeshFrilled_HW", 0.5,
	"Base.TannedLeather_Skirt_MeshFrilled_LW", 0.5,
	"Base.TannedLeather_Skirt_MeshFrilled_LerW", 0.5,
	"Base.TannedLeather_SkirtMicro_Mesh", 0.5,
	"Base.TannedLeather_SkirtMicro_MeshFrilled", 0.5,
	"Base.TannedLeather_Long_Skirt", 0.5,
	"Base.TannedLeather_Skirt_Mid", 0.5,
	"Base.TannedLeather_Skirt_Short", 0.5,
	"Base.TannedLeather_Skirt_Shorter", 0.5,
	"Base.TannedLeather_Loincloth", 0.5,
	"Base.Armour_PouchStrap", 0.5,
	"Base.Armour_Faulds", 0.5,
	"Base.Armour_Faulds_Short", 0.5,
	"Base.Armour_ShoulderPad_R", 0.5,
	"Base.Armour_ShoulderPad_L", 0.5,
	"Base.Armour_Armguards_R", 0.5,
	"Base.Armour_Armguards_L", 0.5,
	"Base.Armour_ArmguardsLong_R", 0.5,
	"Base.Armour_ArmguardsLong_L", 0.5,
	"Base.TannedLeather_SleevesLeg_L", 0.5,
	"Base.TannedLeather_SleevesLeg_R", 0.5,
	"Base.TannedLeather_Sleeves_L", 0.5,
	"Base.TannedLeather_Sleeves_R", 0.5,
	"Base.Hat_Cowboy_Flat", 0.5
)

BatchRuleInjection("LaundryLoad1",
    "Base.FF_Boots_HF_New", 0.1,
    "Base.FF_Boots_HF_New_Longest", 0.1,
    "Base.FF_Boots_HF_New_Longer", 0.1,
    "Base.FF_Boots_HF_New_Long", 0.1,
    "Base.FF_Boots_Leather", 0.1,
    "Base.FF_Boots_Leather_Short", 0.1,
    "Base.FF_Boots_Cowboy", 0.1,
    "Base.FF_Boots_Cowboy_Plain", 0.1,
    "Base.FF_Shoe_Boots_Ankle", 0.1,
    "Base.FF_Shoe_Boots_Ankle_Steel", 0.1,
    "Base.FF_Boots_Common", 0.1,
    "Base.FF_Boots_Platform_Thighhigh", 0.1,
    "Base.FF_Boots_Platform_Kneehigher", 0.1,
    "Base.FF_Boots_Platform_Kneehigh", 0.1,
    "Base.FF_Boots_Platform_Ankle", 0.1,
    "Base.FF_Boots_Platform_AnkleLow", 0.1,
    "Base.FF_Boots_Pointy_AnkleLow", 0.1,
    "Base.FF_Boots_Pointy_Ankle", 0.1,
    "Base.FF_Boots_Pointy_Kneehigh", 0.1,
	"Base.FF_Boots_HF_New", 0.1,
	"Base.FF_Boots_HF_New_Longest", 0.1,
	"Base.FF_Boots_HF_New_Longer", 0.1,
	"Base.FF_Boots_HF_New_Long", 0.1,
	"Base.FF_Shoe_Boots_Ankle_Platform", 0.1,
	"Base.FF_Boots_HighHeels", 0.1,
	"Base.FF_Shoe_Women", 0.1,
	"Base.FF_Shoe_Women_Platform", 0.1,
	"Base.FF_Shoe_Women_2", 0.1,
	"Base.FF_Shoe_Moccasin", 0.1,
	"Base.FF_Boots_UGG_DwarfHeel", 0.1,
	"Base.FF_Boots_UGG_Heel", 0.1,
	"Base.FF_Boots_UGG_ThighhighHeel", 0.1,
	"Base.FF_Boots_UGG_KneehighHeel", 0.1,
	"Base.FF_Boots_UGG", 0.1,
	"Base.FF_Boots_UGG_Thighhigh", 0.1,
	"Base.FF_Boots_UGG_Kneehigh", 0.1,
	"Base.FF_Boots_Leather", 0.1,
	"Base.FF_Boots_Leather_Short", 0.1,
	"Base.FF_Boots_Cowboy", 0.1,
	"Base.FF_Boots_Cowboy_Plain", 0.1,
	"Base.FF_Shoe_Boots_Ankle", 0.1,
	"Base.FF_Shoe_Boots_Ankle_Steel", 0.1,
	"Base.FF_Boots_Common", 0.1,
	"Base.FF_Shoe_Common", 0.1,
	"Base.FF_Shoe_Trainers", 0.1,
	"Base.FF_Shoe_TrainersBlack", 0.1,
	"Base.FF_Shoe_TrainersWhite", 0.1,
	"Base.FF_Boots_Platform_Thighhigh", 0.1,
	"Base.FF_Boots_Platform_Kneehigher", 0.1,
	"Base.FF_Boots_Platform_Kneehigh", 0.1,
	"Base.FF_Boots_Platform_Ankle", 0.1,
	"Base.FF_Boots_Platform_AnkleLow", 0.1,
	"Base.FF_Boots_PlatformPunk_Thighhigh", 0.1,
	"Base.FF_Boots_PlatformPunk_Kneehigher", 0.1,
	"Base.FF_Boots_PlatformPunk_Kneehigh", 0.1,
	"Base.FF_Boots_Pointy_AnkleLow", 0.1,
	"Base.FF_Boots_Pointy_Ankle", 0.1,
	"Base.FF_Boots_Pointy_Kneehigh", 0.1,
	"Base.FF_Boots_PointySkull_AnkleLow", 0.1,
	"Base.FF_Boots_PointySkull_Kneehigh", 0.1,
	"Base.FF_BootsRE_Leather_DwarfHeel", 0.1,
	"Base.FF_BootsRE_Leather_Heel", 0.1,
	"Base.FF_BootsRE_Leather_ThighhighHeel", 0.1,
	"Base.FF_BootsRE_Leather_KneehighHeel", 0.1,
	"Base.FF_Boots_Military_Thighhigh", 0.1,
	"Base.FF_Boots_Military_Kneehigher", 0.1,
	"Base.FF_Boots_Military_Kneehigh", 0.1,
	"Base.FF_Boots_Military_Ankle", 0.1
)

BatchRuleInjection("LaundryLoad3",
    "Base.FF_Boots_HF_New", 0.1,
    "Base.FF_Boots_HF_New_Longest", 0.1,
    "Base.FF_Boots_HF_New_Longer", 0.1,
    "Base.FF_Boots_HF_New_Long", 0.1,
    "Base.FF_Boots_Leather", 0.1,
    "Base.FF_Boots_Leather_Short", 0.1,
    "Base.FF_Boots_Cowboy", 0.1,
    "Base.FF_Boots_Cowboy_Plain", 0.1,
    "Base.FF_Shoe_Boots_Ankle", 0.1,
    "Base.FF_Shoe_Boots_Ankle_Steel", 0.1,
    "Base.FF_Boots_Common", 0.1,
    "Base.FF_Boots_Platform_Thighhigh", 0.1,
    "Base.FF_Boots_Platform_Kneehigher", 0.1,
    "Base.FF_Boots_Platform_Kneehigh", 0.1,
    "Base.FF_Boots_Platform_Ankle", 0.1,
    "Base.FF_Boots_Platform_AnkleLow", 0.1,
    "Base.FF_Boots_Pointy_AnkleLow", 0.1,
    "Base.FF_Boots_Pointy_Ankle", 0.1,
    "Base.FF_Boots_Pointy_Kneehigh", 0.1,
	"Base.FF_Boots_HF_New", 0.1,
	"Base.FF_Boots_HF_New_Longest", 0.1,
	"Base.FF_Boots_HF_New_Longer", 0.1,
	"Base.FF_Boots_HF_New_Long", 0.1,
	"Base.FF_Shoe_Boots_Ankle_Platform", 0.1,
	"Base.FF_Boots_HighHeels", 0.1,
	"Base.FF_Shoe_Women", 0.1,
	"Base.FF_Shoe_Women_Platform", 0.1,
	"Base.FF_Shoe_Women_2", 0.1,
	"Base.FF_Shoe_Moccasin", 0.1,
	"Base.FF_Boots_UGG_DwarfHeel", 0.1,
	"Base.FF_Boots_UGG_Heel", 0.1,
	"Base.FF_Boots_UGG_ThighhighHeel", 0.1,
	"Base.FF_Boots_UGG_KneehighHeel", 0.1,
	"Base.FF_Boots_UGG", 0.1,
	"Base.FF_Boots_UGG_Thighhigh", 0.1,
	"Base.FF_Boots_UGG_Kneehigh", 0.1,
	"Base.FF_Boots_Leather", 0.1,
	"Base.FF_Boots_Leather_Short", 0.1,
	"Base.FF_Boots_Cowboy", 0.1,
	"Base.FF_Boots_Cowboy_Plain", 0.1,
	"Base.FF_Shoe_Boots_Ankle", 0.1,
	"Base.FF_Shoe_Boots_Ankle_Steel", 0.1,
	"Base.FF_Boots_Common", 0.1,
	"Base.FF_Shoe_Common", 0.1,
	"Base.FF_Shoe_Trainers", 0.1,
	"Base.FF_Shoe_TrainersBlack", 0.1,
	"Base.FF_Shoe_TrainersWhite", 0.1,
	"Base.FF_Boots_Platform_Thighhigh", 0.1,
	"Base.FF_Boots_Platform_Kneehigher", 0.1,
	"Base.FF_Boots_Platform_Kneehigh", 0.1,
	"Base.FF_Boots_Platform_Ankle", 0.1,
	"Base.FF_Boots_Platform_AnkleLow", 0.1,
	"Base.FF_Boots_PlatformPunk_Thighhigh", 0.1,
	"Base.FF_Boots_PlatformPunk_Kneehigher", 0.1,
	"Base.FF_Boots_PlatformPunk_Kneehigh", 0.1,
	"Base.FF_Boots_Pointy_AnkleLow", 0.1,
	"Base.FF_Boots_Pointy_Ankle", 0.1,
	"Base.FF_Boots_Pointy_Kneehigh", 0.1,
	"Base.FF_Boots_PointySkull_AnkleLow", 0.1,
	"Base.FF_Boots_PointySkull_Kneehigh", 0.1,
	"Base.FF_BootsRE_Leather_DwarfHeel", 0.1,
	"Base.FF_BootsRE_Leather_Heel", 0.1,
	"Base.FF_BootsRE_Leather_ThighhighHeel", 0.1,
	"Base.FF_BootsRE_Leather_KneehighHeel", 0.1,
	"Base.FF_Boots_Military_Thighhigh", 0.1,
	"Base.FF_Boots_Military_Kneehigher", 0.1,
	"Base.FF_Boots_Military_Kneehigh", 0.1,
	"Base.FF_Boots_Military_Ankle", 0.1
)

BatchRuleInjection("LaundryLoad5",
    "Base.FF_Boots_HF_New", 0.1,
    "Base.FF_Boots_HF_New_Longest", 0.1,
    "Base.FF_Boots_HF_New_Longer", 0.1,
    "Base.FF_Boots_HF_New_Long", 0.1,
    "Base.FF_Boots_Leather", 0.1,
    "Base.FF_Boots_Leather_Short", 0.1,
    "Base.FF_Boots_Cowboy", 0.1,
    "Base.FF_Boots_Cowboy_Plain", 0.1,
    "Base.FF_Shoe_Boots_Ankle", 0.1,
    "Base.FF_Shoe_Boots_Ankle_Steel", 0.1,
    "Base.FF_Boots_Common", 0.1,
    "Base.FF_Boots_Platform_Thighhigh", 0.1,
    "Base.FF_Boots_Platform_Kneehigher", 0.1,
    "Base.FF_Boots_Platform_Kneehigh", 0.1,
    "Base.FF_Boots_Platform_Ankle", 0.1,
    "Base.FF_Boots_Platform_AnkleLow", 0.1,
    "Base.FF_Boots_Pointy_AnkleLow", 0.1,
    "Base.FF_Boots_Pointy_Ankle", 0.1,
    "Base.FF_Boots_Pointy_Kneehigh", 0.1,
	"Base.FF_Boots_HF_New", 0.1,
	"Base.FF_Boots_HF_New_Longest", 0.1,
	"Base.FF_Boots_HF_New_Longer", 0.1,
	"Base.FF_Boots_HF_New_Long", 0.1,
	"Base.FF_Shoe_Boots_Ankle_Platform", 0.1,
	"Base.FF_Boots_HighHeels", 0.1,
	"Base.FF_Shoe_Women", 0.1,
	"Base.FF_Shoe_Women_Platform", 0.1,
	"Base.FF_Shoe_Women_2", 0.1,
	"Base.FF_Shoe_Moccasin", 0.1,
	"Base.FF_Boots_UGG_DwarfHeel", 0.1,
	"Base.FF_Boots_UGG_Heel", 0.1,
	"Base.FF_Boots_UGG_ThighhighHeel", 0.1,
	"Base.FF_Boots_UGG_KneehighHeel", 0.1,
	"Base.FF_Boots_UGG", 0.1,
	"Base.FF_Boots_UGG_Thighhigh", 0.1,
	"Base.FF_Boots_UGG_Kneehigh", 0.1,
	"Base.FF_Boots_Leather", 0.1,
	"Base.FF_Boots_Leather_Short", 0.1,
	"Base.FF_Boots_Cowboy", 0.1,
	"Base.FF_Boots_Cowboy_Plain", 0.1,
	"Base.FF_Shoe_Boots_Ankle", 0.1,
	"Base.FF_Shoe_Boots_Ankle_Steel", 0.1,
	"Base.FF_Boots_Common", 0.1,
	"Base.FF_Shoe_Common", 0.1,
	"Base.FF_Shoe_Trainers", 0.1,
	"Base.FF_Shoe_TrainersBlack", 0.1,
	"Base.FF_Shoe_TrainersWhite", 0.1,
	"Base.FF_Boots_Platform_Thighhigh", 0.1,
	"Base.FF_Boots_Platform_Kneehigher", 0.1,
	"Base.FF_Boots_Platform_Kneehigh", 0.1,
	"Base.FF_Boots_Platform_Ankle", 0.1,
	"Base.FF_Boots_Platform_AnkleLow", 0.1,
	"Base.FF_Boots_PlatformPunk_Thighhigh", 0.1,
	"Base.FF_Boots_PlatformPunk_Kneehigher", 0.1,
	"Base.FF_Boots_PlatformPunk_Kneehigh", 0.1,
	"Base.FF_Boots_Pointy_AnkleLow", 0.1,
	"Base.FF_Boots_Pointy_Ankle", 0.1,
	"Base.FF_Boots_Pointy_Kneehigh", 0.1,
	"Base.FF_Boots_PointySkull_AnkleLow", 0.1,
	"Base.FF_Boots_PointySkull_Kneehigh", 0.1,
	"Base.FF_BootsRE_Leather_DwarfHeel", 0.1,
	"Base.FF_BootsRE_Leather_Heel", 0.1,
	"Base.FF_BootsRE_Leather_ThighhighHeel", 0.1,
	"Base.FF_BootsRE_Leather_KneehighHeel", 0.1,
	"Base.FF_Boots_Military_Thighhigh", 0.1,
	"Base.FF_Boots_Military_Kneehigher", 0.1,
	"Base.FF_Boots_Military_Kneehigh", 0.1,
	"Base.FF_Boots_Military_Ankle", 0.1
)

BatchRuleInjection("LaundryLoad7",
    "Base.FF_Boots_HF_New", 0.1,
    "Base.FF_Boots_HF_New_Longest", 0.1,
    "Base.FF_Boots_HF_New_Longer", 0.1,
    "Base.FF_Boots_HF_New_Long", 0.1,
    "Base.FF_Boots_Leather", 0.1,
    "Base.FF_Boots_Leather_Short", 0.1,
    "Base.FF_Boots_Cowboy", 0.1,
    "Base.FF_Boots_Cowboy_Plain", 0.1,
    "Base.FF_Shoe_Boots_Ankle", 0.1,
    "Base.FF_Shoe_Boots_Ankle_Steel", 0.1,
    "Base.FF_Boots_Common", 0.1,
    "Base.FF_Boots_Platform_Thighhigh", 0.1,
    "Base.FF_Boots_Platform_Kneehigher", 0.1,
    "Base.FF_Boots_Platform_Kneehigh", 0.1,
    "Base.FF_Boots_Platform_Ankle", 0.1,
    "Base.FF_Boots_Platform_AnkleLow", 0.1,
    "Base.FF_Boots_Pointy_AnkleLow", 0.1,
    "Base.FF_Boots_Pointy_Ankle", 0.1,
    "Base.FF_Boots_Pointy_Kneehigh", 0.1,
	"Base.FF_Boots_HF_New", 0.1,
	"Base.FF_Boots_HF_New_Longest", 0.1,
	"Base.FF_Boots_HF_New_Longer", 0.1,
	"Base.FF_Boots_HF_New_Long", 0.1,
	"Base.FF_Shoe_Boots_Ankle_Platform", 0.1,
	"Base.FF_Boots_HighHeels", 0.1,
	"Base.FF_Shoe_Women", 0.1,
	"Base.FF_Shoe_Women_Platform", 0.1,
	"Base.FF_Shoe_Women_2", 0.1,
	"Base.FF_Shoe_Moccasin", 0.1,
	"Base.FF_Boots_UGG_DwarfHeel", 0.1,
	"Base.FF_Boots_UGG_Heel", 0.1,
	"Base.FF_Boots_UGG_ThighhighHeel", 0.1,
	"Base.FF_Boots_UGG_KneehighHeel", 0.1,
	"Base.FF_Boots_UGG", 0.1,
	"Base.FF_Boots_UGG_Thighhigh", 0.1,
	"Base.FF_Boots_UGG_Kneehigh", 0.1,
	"Base.FF_Boots_Leather", 0.1,
	"Base.FF_Boots_Leather_Short", 0.1,
	"Base.FF_Boots_Cowboy", 0.1,
	"Base.FF_Boots_Cowboy_Plain", 0.1,
	"Base.FF_Shoe_Boots_Ankle", 0.1,
	"Base.FF_Shoe_Boots_Ankle_Steel", 0.1,
	"Base.FF_Boots_Common", 0.1,
	"Base.FF_Shoe_Common", 0.1,
	"Base.FF_Shoe_Trainers", 0.1,
	"Base.FF_Shoe_TrainersBlack", 0.1,
	"Base.FF_Shoe_TrainersWhite", 0.1,
	"Base.FF_Boots_Platform_Thighhigh", 0.1,
	"Base.FF_Boots_Platform_Kneehigher", 0.1,
	"Base.FF_Boots_Platform_Kneehigh", 0.1,
	"Base.FF_Boots_Platform_Ankle", 0.1,
	"Base.FF_Boots_Platform_AnkleLow", 0.1,
	"Base.FF_Boots_PlatformPunk_Thighhigh", 0.1,
	"Base.FF_Boots_PlatformPunk_Kneehigher", 0.1,
	"Base.FF_Boots_PlatformPunk_Kneehigh", 0.1,
	"Base.FF_Boots_Pointy_AnkleLow", 0.1,
	"Base.FF_Boots_Pointy_Ankle", 0.1,
	"Base.FF_Boots_Pointy_Kneehigh", 0.1,
	"Base.FF_Boots_PointySkull_AnkleLow", 0.1,
	"Base.FF_Boots_PointySkull_Kneehigh", 0.1,
	"Base.FF_BootsRE_Leather_DwarfHeel", 0.1,
	"Base.FF_BootsRE_Leather_Heel", 0.1,
	"Base.FF_BootsRE_Leather_ThighhighHeel", 0.1,
	"Base.FF_BootsRE_Leather_KneehighHeel", 0.1,
	"Base.FF_Boots_Military_Thighhigh", 0.1,
	"Base.FF_Boots_Military_Kneehigher", 0.1,
	"Base.FF_Boots_Military_Kneehigh", 0.1,
	"Base.FF_Boots_Military_Ankle", 0.1
)


BatchRuleInjection("SafehouseArmor",
	"Base.Armour_PouchStrap", 2,
	"Base.Armour_Faulds", 2,
	"Base.Armour_Faulds_Short", 2,
	"Base.Armour_ShoulderPad_R", 2,
	"Base.Armour_ShoulderPad_L", 2,
	"Base.Armour_Armguards_R", 2,
	"Base.Armour_Armguards_L", 2,
	"Base.Armour_ArmguardsLong_R", 2,
	"Base.Armour_ArmguardsLong_L", 2,
	"Base.TannedLeather_SleevesLeg_L", 2,
	"Base.TannedLeather_SleevesLeg_R", 2,
	"Base.TannedLeather_Sleeves_L", 2,
	"Base.TannedLeather_Sleeves_R", 2,
	"Base.Hat_Cowboy_Flat", 2,
	"Base.TannedLeather_Long_Skirt", 2,
	"Base.TannedLeather_Skirt_Mid", 2,
	"Base.TannedLeather_Skirt_Short", 2,
	"Base.TannedLeather_Skirt_Shorter", 2,
	"Base.TannedLeather_Loincloth", 2
)


    -- Add more containers as needed...